#!/usr/bin/python3

import ubus
import json

params = [ "Device.XMPP.Connection.1.Alias",
"Device.XMPP.Connection.1.Domain",
"Device.XMPP.Connection.1.Enable",
"Device.XMPP.Connection.1.JabberID",
"Device.XMPP.Connection.1.KeepAliveInterval",
"Device.XMPP.Connection.1.Password",
"Device.XMPP.Connection.1.Resource",
"Device.XMPP.Connection.1.Server.1.Alias",
"Device.XMPP.Connection.1.Server.1.Enable",
"Device.XMPP.Connection.1.Server.1.Port",
"Device.XMPP.Connection.1.Server.1.ServerAddress",
"Device.XMPP.Connection.1.ServerConnectAlgorithm",
"Device.XMPP.Connection.1.ServerConnectAttempts",
"Device.XMPP.Connection.1.ServerNumberOfEntries",
"Device.XMPP.Connection.1.ServerRetryInitialInterval",
"Device.XMPP.Connection.1.ServerRetryIntervalMultiplier",
"Device.XMPP.Connection.1.ServerRetryMaxInterval",
"Device.XMPP.Connection.1.Status",
"Device.XMPP.Connection.1.UseTLS",
"Device.XMPP.Connection.1.Username",
"Device.XMPP.ConnectionNumberOfEntries",
"Device.XMPP.SupportedServerConnectAlgorithms"
];

TEST_NAME = "Validate XMPP param"

print("Running: " + TEST_NAME)

assert ubus.connect()

for x in params:
    res = ubus.call("bbfdm", "get", {"path":x, "optional":{"format":"raw"}})
    val = res[0]["results"][0]["data"]
    print(x, '=>', val)

ubus.disconnect()

print("PASS: " + TEST_NAME)
