/*
 * xuci.h - XMPP uci API functions
 *
 * Copyright (C) 2022, IOPSYS Software Solutions AB.
 *
 * Author: Amin Ben Ramdhane <amin.benramdhane@pivasoftware.com>
 *
 * See LICENSE file for license related information.
 *
 */
#ifndef _XMPPUCI_H_
#define _XMPPUCI_H_

#include <uci.h>

void xmpp_uci_init(void);
void xmpp_uci_fini(void);

struct uci_section *xmpp_uci_walk_section(const char *package, const char *section_type, struct uci_section *prev_section);
char *xmpp_uci_get_value_bysection(struct uci_section *section, const char *option);
char *xmpp_uci_get_value(const char *package, const char *section, const char *option);
int xmpp_var_state_set_value(const char *path, const char *value);

#define xmpp_uci_foreach_section(package, section_type, section) \
	for (section = xmpp_uci_walk_section(package, section_type, NULL); \
		section != NULL; \
		section = xmpp_uci_walk_section(package, section_type, section))

#endif /* _XMPPUCI_H_ */
