/*
 * xmpp.h - XMPP core
 *
 * Copyright (C) 2022, IOPSYS Software Solutions AB.
 *
 * Author: Amin Ben Ramdhane <amin.benramdhane@pivasoftware.com>
 *
 * See LICENSE file for license related information.
 *
 */

#ifndef _XMPP_H_
#define _XMPP_H_

#include <stdbool.h>

#define XMPP_STATS_PATH						"/tmp/.xmppc_stats"
#define XMPP_CR_NS							"urn:broadband-forum-org:cwmp:xmppConnReq-1-0"
#define XMPP_ERROR_NS						"urn:ietf:params:xml:ns:xmpp-stanzas"
#define DEFAULT_RETRY_INITIAL_INTERVAL		60
#define DEFAULT_RETRY_INTERVAL_MULTIPLIER	2000
#define DEFAULT_RETRY_MAX_INTERVAL			30720
#define DEFAULT_XMPP_RECONNECTION_RETRY		5

#ifndef FREE
#define FREE(x) do { if(x) {free(x); x = NULL;} } while (0)
#endif

#ifndef STRLEN
#define STRLEN(SRC) ((SRC != NULL) ? strlen(SRC) : 0)
#endif

enum xmpp_cr_error {
	XMPP_CR_NO_ERROR = 0,
	XMPP_SERVICE_UNAVAILABLE,
	XMPP_NOT_AUTHORIZED
};

struct xmpp_config
{
	char *xmpp_allowed_jid;
	unsigned int xmpp_loglevel;
};

struct xmpp_server
{
	char *server_addr;
	unsigned int priority;
	unsigned int port;
	int weight;
};

struct xmpp_connection
{
	char *username;
	char *password;
	char *domain;
	char *resource;
	char *server_algorithm;
	unsigned int connect_attempt;
	unsigned int retry_initial_interval;
	unsigned int retry_interval_multiplier;
	unsigned int retry_max_interval;
	unsigned int attempt_count;
	long keepalive_interval;
	long max_keepalive_fails;
	bool usetls;
	struct xmpp_server *server;
};

struct xmpp_connection_stats
{
	unsigned int received_messages;
	unsigned int transmitted_messages;
	unsigned int received_error_messages;
	unsigned int transmitted_error_messages;
};

extern struct xmpp_config cur_xmpp_conf;

#endif /* _XMPP_H_ */
