/*
 * log.h - XMPP log functions
 *
 * Copyright (C) 2022, IOPSYS Software Solutions AB.
 *
 * Author: Amin Ben Ramdhane <amin.benramdhane@pivasoftware.com>
 *
 * See LICENSE file for license related information.
 *
 */

#ifndef _XMPPLOG_H_
#define _XMPPLOG_H_

#define DEFAULT_LOGLEVEL SINFO

enum xmpp_log_level_enum {
	SCRIT,
	SWARNING,
	SNOTICE,
	SINFO,
	SDEBUG,
	__MAX_SLOG
};

void xmpp_syslog(int priority, const char *format, ...);
void xmpp_syslog_handler(void * const userdata,
			 const xmpp_log_level_t level,
			 const char * const area,
			 const char * const msg);
xmpp_log_level_t xmpp_log_get_level(int conf_loglevel);

#endif /* _XMPPLOG_H_ */
