#!/bin/bash

function cleanup()
{
	echo ""
}

function check_ret()
{
	ret=$1
	if [ "$ret" -ne 0 ]; then
		echo "Validation of last command failed, ret(${ret})"
		exit $ret
	fi

}

function error_on_zero()
{
	ret=$1
	if [ "$ret" -eq 0 ]; then
		echo "Validation of last command failed, ret(${ret})"
		exit $ret
	fi

}

function exec_cmd()
{
	echo "executing $@"
	$@

	if [ $? -ne 0 ]; then
		echo "Failed to execute $@"
		exit 1
	fi
}

function make_clean()
{
	make -C src clean
	rm *.gcno
	rm *.gcda
}

function make_build()
{
	export CFLAGS="-g -O0 -fprofile-arcs -ftest-coverage"
	export LDFLAGS="--coverage"
	exec_cmd make -C src
	ln -s ${PWD}/src/xmppc /usr/sbin/xmppc
}

function make_install_lib()
{
	mkdir -p /usr/lib/bbfdm/
	exec_cmd cp src/libxmppc.so /usr/lib/bbfdm/
}

function install_bbfdm()
{
	[ -d "/opt/dev/bbfdm" ] && rm -rf /opt/dev/bbfdm

	if [ -n "${BBFDM_BRANCH}" ]; then
		exec_cmd git clone -b ${BBFDM_BRANCH} https://dev.iopsys.eu/bbf/bbfdm.git /opt/dev/bbfdm
	else
		exec_cmd git clone https://dev.iopsys.eu/bbf/bbfdm.git /opt/dev/bbfdm
	fi

	cd /opt/dev/bbfdm
	./gitlab-ci/install-dependencies.sh install
	./gitlab-ci/setup.sh install
}
