#!/bin/bash

echo "$0 preparation script"
pwd

source ./gitlab-ci/shared.sh

# build package
date +%s > timestamp.log
make_clean
make_build
make_install_lib

supervisorctl update
supervisorctl restart all
sleep 2
supervisorctl status all
exec_cmd ubus wait_for bbfdm

sleep 5
echo "Running python xmpp param test"
./test/python/validate_xmpp.py
sleep 5

supervisorctl stop all
supervisorctl status

#report part
gcovr -r . --xml -o ./funl-test-coverage.xml
gcovr -r .

echo "Checking memory leaks ..."
grep -q "<kind>UninitCondition</kind>" /tmp/memory-report.xml
error_on_zero $?

grep -q "<kind>Leak_PossiblyLost</kind>" /tmp/memory-report.xml
error_on_zero $?

grep -q "<kind>Leak_DefinitelyLost</kind>" /tmp/memory-report.xml
error_on_zero $?

echo "Functional Test :: PASS"
