# XMPP Client

In order to reach the devices that are connected behind NAT, the cwmp protocol introduces alternative method of executing Connection Request via NAT based on XMPP. The xmppc is an implementation of XMPP functionality that performs this feature.

## Configuration File ##

The xmppc UCI configuration is located in **'/etc/config/xmpp'**, and contains 3 sections: **xmpp**, **connection** and **connection\_server**.

```bash
config xmpp 'xmpp'
	option conn_req_connection 'connection_1'
	option allowed_jid ''
	#Log levels: Critical=0, Warning=1, Notice=2, Info=3, Debug=4
	option loglevel '3'

config connection 'connection_1'
	option enable '0'
	option username ''
	option password ''
	option domain 	''
	option resource ''
	option usetls '0'
	option interval '30'
	option max_keepalive_fails '5'
	option attempt '16'
	option initial_retry_interval '1'
	option retry_interval_multiplier '1000'
	option retry_max_interval '1'
	option serveralgorithm 'DNS-SRV'

config connection_server 'connection_1_srv_1'
	option con_name 'connection_1'
	option enable '0'
	option priority '0'
	option weight '-1'
	option port '5222'
	option server_address ''
```

For more info on the `xmppc` UCI configuration see [link](./docs/api/uci.xmpp.md)

## Dependencies ##

To successfully build xmpp, the following libraries are needed:

| Dependency  | Link                                        | License                      |
| ----------- | ------------------------------------------- | ---------------------------- |
| libuci      | https://git.openwrt.org/project/uci.git     | LGPL 2.1                     |
| libubox     | https://git.openwrt.org/project/libubox.git | BSD                          |
| libubus     | https://git.openwrt.org/project/ubus.git    | LGPL 2.1                     |
| libstrophe  | https://github.com/strophe/libstrophe       | Dual License (MIT and GPLv3) |

