#!/bin/bash

set -euxo pipefail

echo "install wifimngr dependencies"

pwd

# libeasy
cd /opt/dev
rm -fr libeasy
git clone -b devel https://dev.iopsys.eu/hal/libeasy.git
cd libeasy
cmake .
make CFLAGS+="-I/usr/include/libnl3"
mkdir -p /usr/include/easy
cp easy.h event.h utils.h if_utils.h debug.h hlist.h bufutil.h cryptutil.h ecc_cryptutil.h timestamp.h /usr/include/easy
cp -a libeasy*.so* /usr/lib

# libwifiutils + libwifi
cd /opt/dev
rm -fr libwifi
git clone -b devel https://dev.iopsys.eu/hal/libwifi.git
cd libwifi
cd libwifiutils
cmake .
make -j$(nproc)
cp wifidefs.h wifiutils.h /usr/include
cp -a libwifiutils.so /usr/lib
cd -
cd libwifi
cmake . -DHAS_WIFI=ON
make -j$(nproc)
cp wifiops.h wifi.h /usr/include
cp -a libwifi-7*.so* /usr/lib
sudo ldconfig
