// SPDX-License-Identifier: GPL-2.0-only
/*
 * wifimngr_opts.h - header file for wifimngr cmdline options.
 *
 * Copyright (C) 2025 Genexis AB.
 *
 * Author: Anjan Chanda <anjan.chanda@genexis.eu>
 *
 */

#ifndef WIFIMNGR_OPTS_H
#define WIFIMNGR_OPTS_H

#define DEFAULT_WIFI_EVMAP_JSON_FILE	"/etc/wifi.json"
#define DEFAULT_WIFI_CONFFILE		"wireless"

struct wifimngr_cmdline_opts {
	const char *ubus_socket;
	const char *evmap_file;
	const char *conffile;
	uint32_t features;
	int loglevel;
	const char *logfile;
	bool logfile_isfifo;
	bool syslogging;
};

#endif /* WIFIMNGR_OPTS_H */
