#!/bin/bash

set -euxo pipefail

echo "install dependencies"

pwd

# libeasy
cd /opt/dev
rm -fr libeasy
git clone -b release-7.5 https://dev.iopsys.eu/hal/libeasy.git
cd libeasy
make CFLAGS+="-I/usr/include/libnl3"
mkdir -p /usr/include/easy
cp easy.h event.h utils.h if_utils.h debug.h hlist.h bufutil.h cryptutil.h ecc_cryptutil.h timestamp.h /usr/include/easy
cp -a libeasy*.so* /usr/lib

# libwifi
cd /opt/dev
rm -fr libwifi
git clone -b release-7.5 https://dev.iopsys.eu/hal/libwifi.git
cd libwifi
WIFI_TYPE=TEST CFLAGS="-DHAS_WIFI=1" make
cp wifidefs.h wifiutils.h wifiops.h wifi.h /usr/include
cp -a libwifi*.so* /usr/lib
sudo ldconfig
