# WiFi Operate Commands – TR-181 USP Reference

This document describes `operate` commands supported by the WiFi Data Model, explaining their purposes and providing practical examples using `dmcli`. These commands follow TR-181 Data Model and are applicable in TR-369/USP protocol environments.


## `Device.WiFi.Reset()`

**Purpose:** Resets or Reloads the Wi-Fi subsystem without resetting or rebooting the entire device. Internally, it runs `/sbin/wifi reload` to reload the WiFi stack in case EasyMesh is not enabled. Otherwise, it runs `ubus call map.agent reset` to reset the WiFi Stack.

**Example Output:**

```bash
root@device:~# dmcli do "Device.WiFi.Reset()"
{}
```


## `Device.WiFi.NeighboringWiFiDiagnostic()`

**Purpose:** Scans and lists all nearby WiFi SSIDs visible to the device. When invoked, this command performs the following steps:

* Triggers a scan on each supported radio by executing `ubus call wifi.radio.XXX scan` (where XXX is the device name of the radio)
* Waits for `scan_finished` event from each radio to ensure the scan is complete
* Once scanning is complete, retrieves the results for each radio using `ubus call wifi.radio.XXX scanresults`

**Outputs:**

* `Status`
* `Result.{i}.BSSID`
* `Result.{i}.Channel`
* `Result.{i}.EncryptionMode`
* `Result.{i}.OperatingChannelBandwidth`
* `Result.{i}.OperatingFrequencyBand`
* `Result.{i}.OperatingStandards`
* `Result.{i}.Radio`
* `Result.{i}.SSID`
* `Result.{i}.SecurityModeEnabled`
* `Result.{i}.SignalStrength`

**Example Output:**

```bash
root@device:~# dmcli do "Device.WiFi.NeighboringWiFiDiagnostic()"
{
  "Status": "Complete",
  "Result": [
    {
      "Radio": "Device.WiFi.Radio.1",
      "SSID": "IOPSYS-1460",
      "BSSID": "80:ca:4b:e5:14:62",
      "Channel": "1",
      "OperatingFrequencyBand": "2.4GHz",
      "SignalStrength": "-74",
      "OperatingChannelBandwidth": "20MHz",
      "OperatingStandards": "b,g,n,ac,ax,be",
      "SecurityModeEnabled": "WPA3-Personal-Transition",
      "EncryptionMode": "CCMP"
    }
  ]
}
```


## `Device.WiFi.AccessPoint.{i}.Security.Reset()`

**Purpose:** Resets an Access Point's security settings to default. Currently, it :

* Sets `encryption` to `psk`
* Sets `key` to hardware default key using `$(db get hw.board.wpa_key)`
* If the AP is a standalone AP then sets `wps_pushbutton` to `1`

**Example Output:**

```bash
root@device:~# dmcli do "Device.WiFi.AccessPoint.1.Security.Reset()"
{}
```


## `Device.WiFi.AccessPoint.{i}.WPS.InitiateWPSPBC()`

**Purpose:** Initiates a Wi-Fi Protected Setup (WPS) Push Button Configuration (PBC) process. Currently, this command triggers `ubus call hostapd.XXX wps_start` with `XXX` is the AP ifname

**Outputs:**

* `Status`

**Example Output:**

```bash
root@device:~# dmcli do "Device.WiFi.AccessPoint.2.WPS.InitiateWPSPBC()"
{
  "Status": "Success"
}
```


## `Device.WiFi.DataElements.Network.SetTrafficSeparation()`

**Purpose:** Enables VLAN-based traffic separation per SSID.

**Inputs:**

* `Enable`
* `SSIDtoVIDMapping.{i}.SSID`
* `SSIDtoVIDMapping.{i}.VID`

**Outputs:**

* `Status`

**Example Output:**

```bash

```


## `Device.WiFi.DataElements.Network.SetSSID()`

**Purpose:** Adds, removes, or modifies SSIDs.

**Inputs:**

* `AKMsAllowed`
* `AddRemoveChange`
* `AdvertisementEnabled`
* `Band`
* `Enable`
* `HaulType`
* `MFPConfig`
* `PassPhrase`
* `SSID`

**Outputs:**

* `Status`

**Example Output:**

```bash

```


## `Device.WiFi.DataElements.Network.Device.{i}.SetSTASteeringState()`

**Purpose:** Allows/disallows STA steering from the EasyMesh controller. Currently it:

* Sets `steer_disallow` to `Disallowed(input value)` in the specific node section
* Reload mapcontroller

**Inputs:**

* `Disallowed`

**Outputs:**

* `Status`

**Example Output:**

```bash
root@device:~# dmcli do "Device.WiFi.DataElements.Network.Device.1.SetSTASteeringState()" Disallowed=true
{
  "Status": "Success"
}
```


## `Device.WiFi.DataElements.Network.Device.{i}.MultiAPDevice.Backhaul.SteerWiFiBackhaul()`

**Purpose:** Steers the backhaul link to a different BSS. Currently, it triggers ``

**Inputs:**

* `TargetBSS`
* `TimeOut`

**Outputs:**

* `Status`

**Example Output:**

```bash
root@device:~# dmcli get Device.WiFi.DataElements.Network.Device.2.BackhaulMACAddress
Device.WiFi.DataElements.Network.Device.
└── 2.
    └── BackhaulMACAddress : 96:3f:0c:bc:a8:23
root@device:~# 
root@device:~# dmcli do "Device.WiFi.DataElements.Network.Device.2.MultiAPDevice.Backhaul.SteerWiFiBackhaul()" TargetBSS=96:3f:0c:bc:a8:22 TimeOut=60
{
  "Status": "Success"
}
root@device:~# 
root@device:~# dmcli get Device.WiFi.DataElements.Network.Device.2.BackhaulMACAddress
Device.WiFi.DataElements.Network.Device.
└── 2.
    └── BackhaulMACAddress : 96:3f:0c:bc:a8:22
root@device:~# 
```


## `Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.ChannelScanRequest()`

**Purpose:** Requests a scan on specific channels for a given radio.

**Inputs:**

* `ChannelList`
* `OpClass`

**Outputs:**

* `Status`

**Example Output:**

```bash
root@device:~# dmcli do "Device.WiFi.DataElements.Network.Device.1.Radio.1.ChannelScanRequest()" ChannelList="100, 177"
{
  "Status": "Success"
}
root@device:~# dmcli get -r Device.WiFi.DataElements.Network.Device.1.Radio.1.ScanResultNumberOfEntries
Device.WiFi.DataElements.Network.Device.
└── 1.
    └── Radio.
        └── 1.
            └── ScanResultNumberOfEntries : 1
root@device:~# 
```


## `Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.BSS.{i}.STA.{i}.ClientSteer()`

**Purpose:** Requests client (STA) steering to a new BSSID from the controller.

**Inputs:**

* `TargetBSSID`
* `BTMAbridged`
* `BTMDisassociationTimer`

**Outputs:**

* `Status`

**Example Output:**

```bash
root@device:~# dmcli get Device.WiFi.DataElements.Network.Device.*.Radio.*.BSS.*.STA.*.MACAddress
Device.WiFi.DataElements.Network.Device.
└── 1.
    └── Radio.
        └── 1.
            └── BSS.
                ├── 1.
                │   └── STA.
                │       └── 1.
                │           └── MACAddress : 22:15:68:bb:c4:d1
                └── 2.
                    └── STA.
                        └── 1.
                            └── MACAddress : 44:d4:37:71:bf:7f
root@device:~# 
root@device:~# dmcli get Device.WiFi.DataElements.Network.Device.*.Radio.*.BSS.*.BSSID
Device.WiFi.DataElements.Network.Device.
├── 1.Radio.
│   ├── 1.BSS.
│   │   ├── 1.
│   │   │   └── BSSID : 94:3f:0c:bc:a8:23
│   │   └── 2.
│   │       └── BSSID : 96:3f:0c:bc:a8:23
│   └── 2.BSS.
│       ├── 1.
│       │   └── BSSID : 94:3f:0c:bc:a8:22
│       └── 2.
│           └── BSSID : 96:3f:0c:bc:a8:22
└── 2.Radio.
    ├── 1.BSS.
    │   ├── 1.
    │   │   └── BSSID : fa:d4:37:71:bf:7f
    │   └── 2.
    │       └── BSSID : fa:d4:37:71:bf:70
    └── 2.BSS.
        ├── 1.
        │   └── BSSID : fe:d4:37:71:bf:78
        └── 2.
            └── BSSID : fe:d4:37:71:bf:79
root@device:~# 
root@device:~# dmcli do "Device.WiFi.DataElements.Network.Device.1.Radio.1.BSS.1.STA.1.ClientSteer()" TargetBSSID=fe:d4:37:71:bf:78 BTMDisassociationTimer=20 BTMAbridged=0
{
  "Status": "Success"
}
root@device:~# 
root@device:~# dmcli get Device.WiFi.DataElements.Network.Device.*.Radio.*.BSS.*.STA.*.MACAddress
Device.WiFi.DataElements.Network.Device.
├── 1.Radio.
│   └── 1.
│       └── BSS.
│           └── 2.
│               └── STA.
│                   └── 1.
│                       └── MACAddress : 44:d4:37:71:bf:7f
└── 2.Radio.
    └── 2.
        └── BSS.
            └── 1.
                └── STA.
                    └── 1.
                        └── MACAddress : 22:15:68:bb:c4:d1
root@device:~# 
```


## `Device.WiFi.DataElements.Network.Device.{i}.InitiateWPSPBC()`

**Purpose:** Initiates a Wi-Fi Protected Setup (WPS) Push Button Configuration (PBC) process.

* Currently it is allowed to initiate the Push Button Configuration on gateway controller device only

**Example Output:**

```bash
root@device:~# dmcli do "Device.WiFi.DataElements.Network.Device.1.InitiateWPSPBC()"
{
  "Status": "Success"
}
root@device:~#
```


