# How to Manage WiFi Network using TR181

## Aim
Currently TR181 (2.19.1) provides multiple ways to manage WiFi network, this guide/document describes do/don't/how for most common operations done by Operator/End-User.

## TR181 WiFi Object

TR181 provides `Device.WiFi` object to manage the Wireless network which includes

- Native nodes:

1. `WiFi.Radio.`
2. `WiFi.SSID.`
3. `WiFi.AccessPoint.`

- EasyMesh Node:

1. `WiFi.DataElements.Network.`

Native nodes responsible to manage Wireless on Current CPE, where as EasyMesh Node(DataElements.Network.) meant for whole home wireless management.

### Open Issues

1. Currently there is no standard way to identify if Native nodes are part of EasyMesh Network or its a standalone configuration
2. Some configuration only applicable with Standalone native node, (like Radius Configuration, WPA3 support etc...)
3. No standard way to add/list MLD units

### datamodel handling

To address the open issues and to provide a seamless experience for basic wireless management, we extended the TR181 support with the help of vendor extensions

1. A newly added AccessPoint/SSID from TR181, will result into Easymesh FrontHaul AP
2. Vendor extension in `WiFi.AccessPoint.X_IOWRT_EU_MultiAPMode` to show and configure 'multi_ap' flag in wireless config, this will allow user/operator to de-link/convert an EasyMesh FrontHaul AP to standalone AP, users/operators only allowed to update this value from '2' (fronthaul AP) to '0' (Standalone AP)
3. Setting of `WiFi.SSID.{i}.MLDUnit` only allowed if the device is MLO capabled and has EasyMesh enabled. Further more MLDUnit is only applicable to SSID instance that is/would be commissioned in an EasyMesh AccessPoint.
4. In case of User/Operator set the MLDUnit to '-1', this will result into de-linking the fronthaul-AP from MLD and will result into a SLO interface
5. In case of User/Operator set the MLDUnit to a value for which mld-unit already exits, then it will apply the SSID/Credentials from 'config mld' section to this new SSID and AccessPoint instance
6. In case of User/Operator updates any details using Native nodes, datamodel will propagate that details to mapcontroller (in case of multi_ap=2) and it will result into updation of SSID/Key in 'config mld' section as well if Native node is part of a existing MLD Unit
7. `SetSSID()` operate command will be optimized to check if the configuration applied to network or not, it may take upto 70 seconds to return
8. In extender device (Easymesh disabled), parameters underneath `Device.WiFi.AccessPoint.` and `Device.WiFi.SSID.` DM objects are not configurable for the AccessPoint instances which has multi_ap=2 and for the SSID instances which are commissioned in an AccessPoint having multi_ap=2
9. Setting of any DM parameter using Native objects, datamodel will navigate that to `mapcontroller` in case of EasyMesh nodes and to the `wireless` in case of standalone nodes.
10. Datamodel syncs the configuration of different types of node as below:
    - If multi_ap=2 and easymesh=enable then use mapcontroller UCI.
    - If multi_ap=2 and easymesh=false then use wireless UCI.
    - If multi_ap=0 then use wireless UCI.

## Limitations

1. There are a few parameters underneath Native datamodel objects (shown below), which are not supported to configure on Easymesh nodes as of now.
   - Device.WiFi.AccessPoint.{i}.
       - SSIDAdvertisementEnabled
       - WMMEnable
       - UAPSDEnable
       - MACAddressControlEnabled
       - MaxAllowedAssociations
       - IsolationEnable
       - AllowedMACAddress
       - WEPKey
   - Device.WiFi.AccessPoint.{i}.Security.
       - PreSharedKey
   - Device.WiFi.AccessPoint.{i}.WPS.
   - Device.WiFi.AccessPoint.{i}.Accounting.
       - ServerIPAddr
       - ServerPort
       - Secret

## References

1. [TR181 - WiFi Theory of Operation](https://device-data-model.broadband-forum.org/index.pdf#%5B%7B%22num%22%3A74%2C%22gen%22%3A0%7D%2C%7B%22name%22%3A%22XYZ%22%7D%2C72.857254%2C729.144%2C0%5D)
2. [TR181 - WiFi datamodel](https://usp-data-models.broadband-forum.org/tr-181-2-19-1-usp.html#D.Device:2.Device.WiFi.)

