# Wireless configuration using TR-181

The purpose of this document is to explain the TR181 datamodel parameters handling/mapping for the wireless configuration.

Before TR181 - v2.13, wifi configuration was modeled for a single device and managed with following objects

- WiFi.Radio.
  - maps to actual wireless radios present in the system, which maps to 'config wifi-device' uci sections of wireless uci
- WiFi.AccessPoint.
  - Provides Access related configuration for a SSID, this maps to 'config wifi-iface' section of wireless uci
- WiFi.SSID.
  - Provides SSID related configuration, which maps to 'config wifi-iface' uci sections of wireless uci, with 'option mode' set as 'ap'
- WiFi.EndPoint.
  - Used to manage/define STA(s) in the system, maps to 'config wifi-iface' uci section of wireless uci, with 'option mode' set as 'sta'


With TR181-2.14(and above), its also possible to manage Easymesh controller configurations, with the help of 'Device.WiFi.DataElements.' object.

So, for a device running Controller, We have two options/ways to manage the wireless,
1. Using New DataElement Node, or
2. Using legacy WiFi (Radio/AccessPoint/SSID) Objects

More information about easymesh available in this [link](https://www.wi-fi.org/discover-wi-fi/specifications)

## Uci examples

Example wireless uci

```bash
config wifi-device 'radio0_band0'
	option band '2g'
	option mlo '1'
	option mlo_capable '1'

config wifi-device 'radio0_band1'
	option band '5g'
	option mlo '1'
	option mlo_capable '1'

config wifi-device 'radio0_band2'
	option band '6g'
	option mlo '1'
	option mlo_capable '1'

config wifi-iface 'wlan00_ap'
	option device 'radio0_band0'
	option ifname 'wlan00'
	option network 'lan'
	option ssid 'IOPSYS-XXX'
	option key 'SecretPassKey'
	option encryption 'sae-mixed'
	option mode 'ap'
	option multi_ap '2'
	option multi_ap_profile '3'
	option disabled '0'
	option multi_ap_backhaul_ssid 'MAP-XXX-BH'
	option multi_ap_backhaul_key '3295a3ec5afa53986332c1d7113a60113d206e0806d1080aec1f9a7d3fc1b4b'
	option mld 'mld2'
	option sae_pwe '2'

config wifi-iface 'wlan00_1_ap'
	option device 'radio0_band0'
	option ifname 'wlan00-1'
	option network 'lan'
	option ssid 'MAP-XXX-BH'
	option key '3295a3ec5afa53986332c1d7113a60113d206e0806d1080aec1f9a7d3fc1b4b'
	option encryption 'sae'
	option mode 'ap'
	option multi_ap '1'
	option multi_ap_profile '3'
	option disabled '0'
	option mld 'mld1'
	option sae_pwe '2'

config wifi-iface 'wlan01_ap'
	option device 'radio0_band1'
	option ifname 'wlan01'
	option network 'lan'
	option ssid 'IOPSYS-XXX'
	option key 'SecretPassKey'
	option encryption 'sae-mixed'
	option mode 'ap'
	option multi_ap '2'
	option multi_ap_profile '3'
	option multi_ap_backhaul_ssid 'MAP-XXX-BH'
	option multi_ap_backhaul_key '3295a3ec5afa53986332c1d7113a60113d206e0806d1080aec1f9a7d3fc1b4b'
	option mld 'mld2'
	option sae_pwe '2'

config wifi-iface 'wlan01_1_ap'
	option device 'radio0_band1'
	option ifname 'wlan01-1'
	option network 'lan'
	option ssid 'MAP-XXX-BH'
	option key '3295a3ec5afa53986332c1d7113a60113d206e0806d1080aec1f9a7d3fc1b4b'
	option encryption 'sae'
	option mode 'ap'
	option multi_ap '1'
	option multi_ap_profile '3'
	option mld 'mld1'
	option sae_pwe '2'

config wifi-iface 'wlan02_ap'
	option device 'radio0_band2'
	option ifname 'wlan02'
	option network 'lan'
	option ssid 'IOPSYS-XXX'
	option key 'SecretPassKey'
	option encryption 'sae'
	option mode 'ap'
	option multi_ap '2'
	option multi_ap_profile '3'
	option multi_ap_backhaul_ssid 'MAP-XXX-BH'
	option multi_ap_backhaul_key '3295a3ec5afa53986332c1d7113a60113d206e0806d1080aec1f9a7d3fc1b4b'
	option mld 'mld2'
	option sae_pwe '2'

config wifi-iface 'wlan02_1_ap'
	option device 'radio0_band2'
	option network 'lan'
	option ssid 'MAP-XXX-BH'
	option key '3295a3ec5afa53986332c1d7113a60113d206e0806d1080aec1f9a7d3fc1b4b'
	option encryption 'sae'
	option mode 'ap'
	option multi_ap '1'
	option multi_ap_profile '3'
	option mld 'mld1'
	option sae_pwe '2'

config wifi-mld 'mld1'
	option sae_pwe '2'
	option ifname 'wlan0'
	option ssid 'MAP-XXX-BH'
	option key '3295a3ec5afa53986332c1d7113a60113d206e0806d1080aec1f9a7d3fc1b4b'

config wifi-mld 'mld2'
	option sae_pwe '2'
	option ifname 'wlan1'
	option ssid 'IOPSYS-XXX'
	option key 'SecretPassKey'
```

Example map-controller uci

```bash
config controller 'controller'
	option enabled '1'
	option profile '3'
	option registrar '2 5 6'
	option enable_ts '0'
	option primary_vid '1'
	option primary_pcp '0'
	option allow_bgdfs '0'
	option channel_plan '0'
	option de_collect_interval '60'

config ap
	option band '2'
	option ssid 'IOPSYS-XXX'
	option encryption 'sae-mixed'
	option key 'SecretPassKey'
	option vid '1'
	option type 'fronthaul'
	option mld_id '1'

config ap
	option band '5'
	option ssid 'IOPSYS-XXX'
	option encryption 'sae-mixed'
	option key 'SecretPassKey'
	option vid '1'
	option type 'fronthaul'
	option mld_id '1'

config ap
	option band '6'
	option ssid 'IOPSYS-XXX'
	option encryption 'sae'
	option key 'SecretPassKey'
	option vid '1'
	option type 'fronthaul'
	option mld_id '1'

config ap
	option band '2'
	option ssid 'MAP-XXX-BH'
	option encryption 'sae'
	option key '3295a3ec5afa53986332c1d7113a60113d206e0806d1080aec1f9a7d3fc1b4b'
	option type 'backhaul'
	option vid '1'
	option mld_id '2'

config ap
	option band '5'
	option ssid 'MAP-XXX-BH'
	option encryption 'sae'
	option key '3295a3ec5afa53986332c1d7113a60113d206e0806d1080aec1f9a7d3fc1b4b'
	option type 'backhaul'
	option vid '1'
	option mld_id '2'

config ap
	option band '6'
	option ssid 'MAP-XXX-BH'
	option encryption 'sae'
	option key '3295a3ec5afa53986332c1d7113a60113d206e0806d1080aec1f9a7d3fc1b4b'
	option type 'backhaul'
	option vid '1'
	option mld_id '2'

config mld
	option id '1'
	option ssid 'IOPSYS-XXX'
	option key 'SecretPassKey'
	option type 'fronthaul'

config mld
	option id '2'
	option ssid 'MAP-XXX-BH'
	option key '3295a3ec5afa53986332c1d7113a60113d206e0806d1080aec1f9a7d3fc1b4b'
	option type 'backhaul'

```

Example map-agent uci

```bash
config agent 'agent'
	option enabled '1'
	option profile '3'
	option al_bridge 'br-lan'

config radio
	option device 'radio0_band0'
	option band '2'

config radio
	option device 'radio0_band1'
	option band '5'

config radio
	option device 'radio0_band2'
	option band '6'

config ap
	option ifname 'wlan00'
	option band '2'
	option device 'radio0_band0'
	option ssid 'IOPSYS-XXX'
	option key 'SecretPassKey'
	option encryption 'sae-mixed'
	option type 'fronthaul'
	option enabled '1'
	list vendor_ie 'b456fa4c0101'
	option mld_id '2'

config ap
	option ifname 'wlan00-1'
	option band '2'
	option device 'radio0_band0'
	option ssid 'MAP-XXX-BH'
	option key '3295a3ec5afa53986332c1d7113a60113d206e0806d1080aec1f9a7d3fc1b4b'
	option encryption 'sae'
	option type 'backhaul'
	option enabled '1'
	list vendor_ie 'b456fa4c0101'
	list disallow_bsta_profile '1'
	option mld_id '1'

config mld
	option id '1'
	option ifname 'wlan0'
	option ssid 'MAP-XXX-BH'
	option key '3295a3ec5afa53986332c1d7113a60113d206e0806d1080aec1f9a7d3fc1b4b'
	option type 'backhaul'

config mld
	option id '2'
	option ifname 'wlan1'
	option ssid 'IOPSYS-XXX'
	option key 'SecretPassKey'
	option type 'fronthaul'

config ap
	option ifname 'wlan01'
	option band '5'
	option device 'radio0_band1'
	option ssid 'IOPSYS-XXX'
	option key 'SecretPassKey'
	option encryption 'sae-mixed'
	option type 'fronthaul'
	option enabled '1'
	list vendor_ie 'b456fa4c0101'
	option mld_id '2'

config ap
	option ifname 'wlan01-1'
	option band '5'
	option device 'radio0_band1'
	option ssid 'MAP-XXX-BH'
	option key '3295a3ec5afa53986332c1d7113a60113d206e0806d1080aec1f9a7d3fc1b4b'
	option encryption 'sae'
	option type 'backhaul'
	option enabled '1'
	list vendor_ie 'b456fa4c0101'
	list disallow_bsta_profile '1'
	option mld_id '1'

config ap
	option ifname 'wlan02'
	option band '6'
	option device 'radio0_band2'
	option ssid 'IOPSYS-XXX'
	option key 'SecretPassKey'
	option encryption 'sae'
	option type 'fronthaul'
	option enabled '1'
	list vendor_ie 'b456fa4c0101'
	option mld_id '2'

config ap
	option ifname 'wlan02-1'
	option band '6'
	option device 'radio0_band2'
	option ssid 'MAP-XXX-BH'
	option key '3295a3ec5afa53986332c1d7113a60113d206e0806d1080aec1f9a7d3fc1b4b'
	option encryption 'sae'
	option type 'backhaul'
	option enabled '1'
	list vendor_ie 'b456fa4c0101'
	option mld_id '1'
	list disallow_bsta_profile '1'

```

## Ambiguity in self node management
Now, with the inclusion of 'DataElement', we have two control points to manage the SSID and AccessPoint related configurations, either with
 - WiFi.DataElements., or
 - WiFi Legacy (Radio/AccessPoint/SSID) Objects


TR181 definition for WiFi management does not address this ambiguity and its bit open for the Easymesh enabled cpe.

To simplify configuration in iowrt deployments:
 - Legacy WiFi Radio/AccessPoint/SSID objects only maps to fronthaul interfaces
 - Updates done using Legacy WiFi Radio/AccessPoint/SSID nodes synced back to `mapcontroller` and `mapagent` uci sections(if available) to reduce the number of reloads and miss-configurations.
 - For WiFi7 enabled devices, 'Device.WiFi.DataElements.Network.SSID.' only maps to 'config ap' sections which are not member of any MLDUnits

> Note: Sync between different uci's done with the help of markers (which usually the section name), Its advised to users/operator to follow the example to create the factory default uci configuration for each module. Also, if users/operator are using external tools to manage the wireless/EasyMesh configuration directly over uci then the ownership to keep all the uci in sync lies to the external tool as well. Out of sync uci sections may result in errors over datamodel layer.

## Easymesh management from TR181
'Device.WiFi.DataElements.' table used for managing Easymesh nodes, regardless of if the node is self node or a remote network node, the management ownership owned by easy-mesh controller.

Easymesh controller provides an ubus object to show the current/active configuration, and an uci to configure the input parameters.

Any configuration update in easymesh uci might take some time to apply the same in network, and to update it in the ubus object output.
So, datamodel parameters which maps to 'WiFi.DataElements.' table might also show the old values until the configuration not propagated to the network node by easymesh controller.

> Note: To verify the new configuration, either user can wait for a significant time before getting the datamodel and verify the configuration, or they can subscribe for ValueChange notification with a max timeout to handler the same.

## WiFi7 related handling

In TR181-2.17 a new parameter added(Device.WiFi.SSID.{i}.MLDUnit) in 'WiFi.SSID.' table to show the MLD association, but there is no object which maps to 'mld' units directly.
This limitation results into complex datamodel mapping, which is explained with use-cases below:

> Note: If an AP/SSID does not belongs to any MLD it has 'MLDUnit' as '-1'

###  User set MLDUnit of a SSID which was having MLDUnit = -1 (not associated with any MLDs)

 - If MLDUnit set-value is 0, return Error
 - If SSID instance is not referred by an AccessPoint instance then user wants to Update MLDUnit then return Error
 - Validate the 'mlo_capable' capability of the radio assigned to the SSID
    - False:
        - If LowerLayer(radio device) of the SSID is not configured, return Error
        - If the mlo capability of the radio is not true, return Error
    - True:
        - Check if the **wifi-mld** section for configured MLDUnit is already exist in **wireless** UCI
            - False:
                - Create a new **wifi-mld** section in **wireless**.
                - Set options *ssid*, *ifname*, *key*, *sae-pwe* of the new *wifi-mld* section.
                - *ssid*, *key* and *sae-pwe* is copied from the *wifi-iface* section of the corresponding SSID/AP.
                - *ifname* is populated as *wlan(mld_id-1)* i.e if mld_id is 2 then *ifname* is wlan1
                - If **mapcontroller** UCI file exists
                    - True:
                        - Create a new **mld** section in **mapcontroller** UCI
                        - Set options *id*, *ssid*, *key*, *type* of the new *mld* section.
                        - *ssid*, *key* copied from the **wifi-iface** section of the SSID/AP, *id* is set to the MLDUnit and *type* set to fronthaul.
                    - False:
                        - Do nothing.
            - True:
                - Do nothing
        - Update AP section in **mapcontroller** UCI only if the file exists
            - If *ap* section of the corresponding wireless *wifi-iface* section not exist
                - Create new **ap** section in mapcontroller and set *band*, *ssid*, *encryption*, *key*, *type* and *mld_id*.
                - *type* is set to fronthaul, *mld_id* is set with MLDUnit value and other options are copied from corresponding *wifi-iface* and *wifi-device* sections in **wireless** UCI.
            - Else
                - Only update the *mld_id* of the corresponding **ap** section with configured MLDUnit
        - Update *mld* option of the corresponding **wifi-iface** (SSID/AP) section in the **wireless** UCI.

### User set MLDUnit value to -1
 - If previous value of MLDUnit was also -1 then no change, if not then
 - Delete *mld* option from the corresponding **wifi-iface** (SSID/AP) section in the **wireless** UCI.
 - Update AP section in **mapcontroller** UCI only if the file exists
    - If *ap* section is not exist for the corresponding *wifi-iface* section of **wireless** UCI
        - Do nothing
    - Else
        - Delete *mld* option from the **ap** section

### User updates the SSID of any SSID instance
 - Update the `ssid` option in the corresponding **wifi-iface** section in **wireless** UCI
 - Validate the **mlo** capability
    - True:
        - If *mld* of the corresponding **wifi-iface** section is valid i.e other than -1
            - Update the *ssid* with new value in the **wifi-mld** section that refers to this *mld* unit
            - If **mapcontroller** UCI file exists
                - update the *ssid* in the corresponding **mld** section
                - update the *ssid* in the corresponding **ap** section
    - False:
        - Do nothing

### User updates the password for the AccessPoint
 - Update the `key` option in the corresponding **wifi-iface** section in **wireless** UCI
 - Validate the **mlo** capability
    - True:
        - If *mld* of the corresponding **wifi-iface** section is valid i.e other than -1
            - Update the *key* with new value in the **wifi-mld** section that refers to this *mld* unit
            - If **mapcontroller** UCI file exists
                - update the *key* in the corresponding **mld** section
                - update the *key* in the corresponding **ap** section
    - False:
        - Do nothing


## Limitations
 - Creating SSID/AccessPoint with legacy nodes, create an EasyMesh AP
 - Only Fronthaul AP(s) visible in legacy nodes.
 - Only one SSID with a specific radio band.
 - Only one AP can refer to a specific SSID instance.
 - MLDUnit is not allowed to update for StandAlond APs.
 - MLDUnit not configurable in the devices which do not support MLD or disabled EasyMesh.
 - Pre-existing Backhaul MLDUnit can't be assigned to a fronthaul SSID.
 - When setting MLDUnit, the SSID of the SSID table might changed internally by adding prefix.
 - A standalone AP is not allowed to change to easymesh AP.
 - A standalone SSID can not be created if there exist an easymesh SSID with same SSID value and vice-versa.
 - On changing an EasyMesh AP to StandAlone AP, it's SSID changes internally by adding some prefix.
 - Fronthaul and Backhaul AP can not have same SSID value.
 - Below parameters are not configurable for Easymesh AP
   - SSIDAdvertisementEnabled
   - WMMEnable
   - UAPSDEnable
   - MACAddressControlEnabled
   - MaxAllowedAssociations
   - IsolationEnable
   - AllowedMACAddress
   - Security.WEPKey
   - Security.PreSharedKey
   - Accounting parameters
   - WPS parameters
 - When changing the AP's security mode to some value that not support radius server, will delete the radius
   server configurations of the AP if there exists any.

