/*
 * Copyright (C) 2024-2025 IOPSYS Software Solutions AB. All rights reserved.
 *
 *
 * See LICENSE file for license related information.
 *
 * Author: Suvendhu Hansa <suvendhu.hansa@iopsys.eu>
 *
 */

#ifndef __COMMON_H
#define __COMMON_H

#include <libbbfdm-api/dmcommon.h>

struct radio_info {
	struct list_head list;
	char radio_name[10];
	char band[5];
};

extern bool mld_capable;
extern bool easymesh_enable;
extern struct list_head dev_list;

char *get_default_key(void);
char *get_default_encryption(void);
char *get_device_from_band(const char *band);
void get_band_from_device(const char *device, char *band, int size);
void remove_unused_mld_sections(void);

#endif
