/*
 * Data types and API prototypes that are shared between voicemngr and asterisk-chan-voicemngr
 */
#ifndef __VOICE_TYPES_H
#define __VOICE_TYPES_H

#include <stdint.h>

#define RTP_HEADER_SIZE    12

typedef enum callid_state {
	CALLID_INVALID = -1,
	CALLID_OBTAINING = 0,
	CALLID_ESTABLISHED = 1
} callid_state;

struct __attribute__((__packed__)) media_packet_t {
	int32_t  line;
	int32_t  connection_id;
	uint32_t rtp_size;
	uint8_t  rtp[1];
};
typedef struct __attribute__((__packed__)) media_packet_t audio_packet_t;//used for asterisk-chan-voicemngr

// ubus request for set codec
enum VOICE_CODEC {
	VOICE_CODEC_G711U,
	VOICE_CODEC_G711A,
	VOICE_CODEC_G722,
	VOICE_CODEC_G723,
	VOICE_CODEC_G726,
	VOICE_CODEC_G729,
};

enum voice_dtmf_mode {
	VOICE_DTMF_NONE,
	VOICE_DTMF_RFC_4733,
	VOICE_DTMF_INBAND,
	VOICE_DTMF_INFO,
	VOICE_DTMF_AUTO,
	VOICE_DTMF_AUTO_INFO,
};

#define UBUS_DATA_CODEC_BIT  1
#define UBUS_DATA_PTIME_BIT  (1<<1)
#define UBUS_DATA_DTMF_BIT  (1<<2)
#define UBUS_DATA_DTMF_PT_BIT  (1<<3)
struct config_update_struct {
	uint8_t mask; // 8 bit mask
	enum VOICE_CODEC codec;
	int ptime;
	enum voice_dtmf_mode dtmf_mode;
	int dtmf_pt;
	// add more if needed
};

// In UBUS request to voicemngr we need to define what this request is about
enum call_action {
	CALL_DEFAULT0,          // answer/release the call for PCM_0
	CALL_DEFAULT1,          // answer/release the call for PCM_1
	CALL_DIGIT_PRESSED,     // DTMF pressed
	CALL_TOGGLE,            // Switch in Call Waiting
	CALL_CONFERENCE,        // Join - start Call Conference
	CALL_DECT_UNAVAILABLE,  // No DECT handset available for call
	CALL_REJECT,            // indicate for call_reject event, upper 16 bits for pcm_id when using
	CALL_MODE_SINGLE,       // indicate the Single Call Mode has been set for DECT line
	CALL_MODE_MULTIPLE,     // indicate the Multiple Call Mode has been set for DECT line
	CALL_LAST
};

/*
 * UBUS related definitions
 */
// Objects
#define DECTMNGR_RPC_UBUS_OBJECT    "dect-rpc"
// Methods
#define DECTMNGR_RPC_CALL_MISSED    "call-missed"
#define DECTMNGR_RPC_RINGING_STOP   "ringing-stop"
#define DECTMNGR_RPC_CALLS_RELEASE  "calls-release"
// Parameters
#define DECTMNGR_RPC_PARAM_EXTENSION_ID  "extension_id"
#define DECTMNGR_RPC_PARAM_PCM_ID        "pcm_id"

#endif
