# Function Specification

*voicemngr* provides the following UBUS objects:

```
'endpt'
	"count":{"effective":"Boolean"}
	"signal":{"line":"Integer","signal":"String","state":"String","data":"String"}
	"connection":{"line":"Integer","id":"Integer","action":"String"}
	"status":{"line":"Integer"}
	"call":{"terminal":"Integer","add":"Integer","release":"Integer","cid":"String","pcm_id":"Integer"}
	"rtp_stats":{"line":"Integer","reset":"Boolean"}
	"codecs":{}
```

# Contents
* [Endpoint](#endpt)

## APIs

*voicemngr* publishes one object, `endpt`.

### endpt

| RPC        | Description                                                                                                    |
|------------|----------------------------------------------------------------------------------------------------------------|
| [count](#count)           | Get the count of voice channels (terminals). This is called by asterisk. |
| [signal](#signal)         | Start/stop call progress tone or signals on a terminal, e.g. dial tone, ring signal, and etc. This is called by asterisk. |
| [connection](#connection) | Create/destroy a connection for a terminal. This is called by asterisk. |
| [status](#status)         | Get the hook status of a terminal. This is called by asterisk. |
| [call](#call)             | Establish/release a call on a terminal. This is called by dectmngr. |
| [rtp_stats](#rtp_stats)   | Get the RTP statistics of a terminal. This is called by asterisk. |
| [codecs](#codecs)   | Get the hardware specific codec capability. This is called by "voice.asterisk codecs". |


#### Methods

Methods descriptions of the `endpt` object.

##### count

[count documentation](./api/endpt.md#count)

##### signal

[signal documentation](./api/endpt.md#signal)

##### connection

[connection documentation](./api/endpt.md#connection)

##### status

[status documentation](./api/endpt.md#status)

##### call

[call documentation](./api/endpt.md#call)

##### rtp_stats

[rtp_stats documentation](./api/endpt.md#rtp_stats)

##### codecs

[codecs documentation](./api/endpt.md#codecs)
