# endpt Schema

```
https://www.iopsys.eu/endpt.json
```

| Custom Properties | Additional Properties |
| ----------------- | --------------------- |
| Forbidden         | Forbidden             |

# endpt

| List of Methods           |
| ------------------------- |
| [call](#call)             | Method | endpt (this schema) |
| [codecs](#codecs)         | Method | endpt (this schema) |
| [connection](#connection) | Method | endpt (this schema) |
| [count](#count)           | Method | endpt (this schema) |
| [rtp_stats](#rtp_stats)   | Method | endpt (this schema) |
| [signal](#signal)         | Method | endpt (this schema) |
| [status](#status)         | Method | endpt (this schema) |

## call

`call`

- type: `Method`

### call Type

`object` with following properties:

| Property | Type   | Required     |
| -------- | ------ | ------------ |
| `input`  | oneOf  | **Required** |
| `output` | object | **Required** |

#### input

`input`

- is **required**
- type: complex

##### input Type

**One** of the following _conditions_ need to be fulfilled.

#### Condition 1

`object` with following properties:

| Property   | Type    | Required     |
| ---------- | ------- | ------------ |
| `add`      | integer | **Required** |
| `cid`      | string  | Optional     |
| `pcm_id`   | integer | **Required** |
| `terminal` | integer | **Required** |

#### add

`add`

- is **required**
- type: `integer`

##### add Type

`integer`

- minimum value: `0`
- maximum value: `5`

#### cid

`cid`

- is optional
- type: `string`

##### cid Type

`string`

- maximum length: 32 characters All instances must conform to this regular expression (test examples
  [here](https://regexr.com/?expression=%5E%5B0-9%5D*%23)):

```regex
^[0-9]*#
```

#### pcm_id

`pcm_id`

- is **required**
- type: `integer`

##### pcm_id Type

`integer`

- minimum value: `0`
- maximum value: `5`

#### terminal

`terminal`

- is **required**
- type: `integer`

##### terminal Type

`integer`

- minimum value: `1`
- maximum value: `6`

#### Condition 2

`object` with following properties:

| Property   | Type    | Required     |
| ---------- | ------- | ------------ |
| `cid`      | string  | Optional     |
| `pcm_id`   | integer | **Required** |
| `release`  | integer | **Required** |
| `terminal` | integer | **Required** |

#### cid

`cid`

- is optional
- type: `string`

##### cid Type

`string`

- maximum length: 32 characters All instances must conform to this regular expression (test examples
  [here](https://regexr.com/?expression=%5E%5B0-9%5D*%23)):

```regex
^[0-9]*#
```

#### pcm_id

`pcm_id`

- is **required**
- type: `integer`

##### pcm_id Type

`integer`

- minimum value: `0`
- maximum value: `5`

#### release

`release`

- is **required**
- type: `integer`

##### release Type

`integer`

- minimum value: `0`
- maximum value: `5`

#### terminal

`terminal`

- is **required**
- type: `integer`

##### terminal Type

`integer`

- minimum value: `1`
- maximum value: `6`

### Ubus CLI Example

```
ubus call endpt call {"terminal":6,"add":1,"pcm_id":0,"cid":"018#"}
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": ["<SID>", "endpt", "call", { "terminal": 6, "add": 1, "pcm_id": 0, "cid": "018#" }]
}
```

#### output

`output`

- is **required**
- type: `object`

##### output Type

`object` with following properties:

| Property   | Type    | Required     |
| ---------- | ------- | ------------ |
| `errno`    | integer | **Required** |
| `pcm`      | integer | **Required** |
| `terminal` | integer | **Required** |

#### errno

`errno`

- is **required**
- type: `integer`

##### errno Type

`integer`

#### pcm

`pcm`

- is **required**
- type: `integer`

##### pcm Type

`integer`

#### terminal

`terminal`

- is **required**
- type: `integer`

##### terminal Type

`integer`

### Output Example

```json
{ "terminal": 73262276, "pcm": -31145049, "errno": -61339135 }
```

## codecs

`codecs`

- type: `Method`

### codecs Type

`object` with following properties:

| Property | Type   | Required     |
| -------- | ------ | ------------ |
| `input`  | object | Optional     |
| `output` | object | **Required** |

#### input

`input`

- is optional
- type: `object`

##### input Type

`object` with following properties:

| Property | Type | Required |
| -------- | ---- | -------- |
| None     | None | None     |

### Ubus CLI Example

```
ubus call endpt codecs {}
```

### JSONRPC Example

```json
{ "jsonrpc": "2.0", "id": 0, "method": "call", "params": ["<SID>", "endpt", "codecs", {}] }
```

#### output

`output`

- is **Required**
- type: `object`

##### output Type

`object` with following properties:

| Property    | Type   | Required     |
| ----------- | ------ | ------------ |
| `codec_key` | object | **Required** |

#### codec_key

`codec_key`

- is **Required**
- type: `object`

##### codec_key Type

`object` with following properties:

| Property          | Type    | Required     |
| ----------------- | ------- | ------------ |
| `bitrate`         | number  | **Required** |
| `name`            | string  | **Required** |
| `ptime_default`   | integer | **Required** |
| `ptime_increment` | integer | **Required** |
| `ptime_max`       | integer | **Required** |
| `ptime_min`       | integer | **Required** |
| `rtp_payload`     | integer | **Optional** |

#### bitrate

`bitrate`

- is **required**
- type: `number`

##### bitrate Type

`number`

- minimum value: `0`
- maximum value: `100`

#### name

`name`

- is **required**
- type: `enum`

##### name Type

`string`

The value of this property **must** be equal to one of the [known values below](#codecs-known-values).

##### name Known Values

| Value      |
| ---------- |
| G.711MuLaw |
| G.711ALaw  |
| G.729a     |
| G.723.1    |
| G.726      |
| G.728      |
| G.729      |
| G.729e     |
| GSM-FR     |
| GSM-EFR    |
| GSM-HR     |
| AMR        |
| iLBC       |

#### ptime_default

`ptime_default`

- is **required**
- type: `integer`

##### ptime_default Type

`integer`

- minimum value: `0`
- maximum value: `50`

#### ptime_increment

`ptime_increment`

- is **required**
- type: `integer`

##### ptime_increment Type

`integer`

- minimum value: `0`
- maximum value: `50`

#### ptime_max

`ptime_max`

- is **required**
- type: `integer`

##### ptime_max Type

`integer`

- minimum value: `0`
- maximum value: `300`

#### ptime_min

`ptime_min`

- is **required**
- type: `integer`

##### ptime_min Type

`integer`

- minimum value: `0`
- maximum value: `50`

#### rtp_payload

`rtp_payload`

- is **optional**
- type: `integer`

##### rtp_payload Type

`integer`

- minimum value: `0`
- maximum value: `127`

### Output Example

```json
{
  "codec_key": {
    "name": "G.729e",
    "ptime_min": 44,
    "ptime_max": 36,
    "ptime_default": 12,
    "ptime_increment": 38,
    "bitrate": 12.60194806517081,
    "rtp_payload": 80
  }
}
```

## connection

`connection`

- type: `Method`

### connection Type

`object` with following properties:

| Property | Type   | Required     |
| -------- | ------ | ------------ |
| `input`  | object | **Required** |
| `output` | object | Optional     |

#### input

`input`

- is **required**
- type: `object`

##### input Type

`object` with following properties:

| Property | Type    | Required     |
| -------- | ------- | ------------ |
| `action` | string  | **Required** |
| `id`     | integer | **Required** |
| `line`   | integer | **Required** |

#### action

`action`

- is **required**
- type: `enum`

##### action Type

`string`

The value of this property **must** be equal to one of the [known values below](#connection-known-values).

##### action Known Values

| Value            |
| ---------------- |
| create           |
| destroy          |
| start_conference |
| stop_conference  |

#### id

`id`

- is **required**
- type: `integer`

##### id Type

`integer`

- minimum value: `0`

#### line

`line`

- is **required**
- type: `integer`

##### line Type

`integer`

- minimum value: `0`
- maximum value: `5`

### Ubus CLI Example

```
ubus call endpt connection {"line":3,"id":4989534,"action":"start_conference"}
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": ["<SID>", "endpt", "connection", { "line": 3, "id": 4989534, "action": "start_conference" }]
}
```

#### output

`output`

- is optional
- type: `object`

##### output Type

`object` with following properties:

| Property | Type | Required |
| -------- | ---- | -------- |
| None     | None | None     |

### Output Example

```json
{}
```

## count

`count`

- type: `Method`

### count Type

`object` with following properties:

| Property | Type   | Required     |
| -------- | ------ | ------------ |
| `input`  | object | **Required** |
| `output` | object | **Required** |

#### input

`input`

- is **required**
- type: `object`

##### input Type

`object` with following properties:

| Property    | Type    | Required     |
| ----------- | ------- | ------------ |
| `effective` | boolean | **Required** |

#### effective

`effective`

- is **required**
- type: `boolean`

##### effective Type

`boolean`

### Ubus CLI Example

```
ubus call endpt count {"effective":true}
```

### JSONRPC Example

```json
{ "jsonrpc": "2.0", "id": 0, "method": "call", "params": ["<SID>", "endpt", "count", { "effective": true }] }
```

#### output

`output`

- is **required**
- type: `object`

##### output Type

`object` with following properties:

| Property             | Type    | Required     |
| -------------------- | ------- | ------------ |
| `num_dect_endpoints` | integer | **Required** |
| `num_endpoints`      | integer | **Required** |
| `num_fxo_endpoints`  | integer | **Required** |
| `num_fxs_endpoints`  | integer | **Required** |

#### num_dect_endpoints

`num_dect_endpoints`

- is **required**
- type: `integer`

##### num_dect_endpoints Type

`integer`

- minimum value: `0`

#### num_endpoints

`num_endpoints`

- is **required**
- type: `integer`

##### num_endpoints Type

`integer`

- minimum value: `0`

#### num_fxo_endpoints

`num_fxo_endpoints`

- is **required**
- type: `integer`

##### num_fxo_endpoints Type

`integer`

- minimum value: `0`

#### num_fxs_endpoints

`num_fxs_endpoints`

- is **required**
- type: `integer`

##### num_fxs_endpoints Type

`integer`

- minimum value: `0`

### Output Example

```json
{
  "num_endpoints": 28959373,
  "num_fxo_endpoints": 16921710,
  "num_fxs_endpoints": 5497405,
  "num_dect_endpoints": 2393708
}
```

## rtp_stats

`rtp_stats`

- type: `Method`

### rtp_stats Type

`object` with following properties:

| Property | Type   | Required     |
| -------- | ------ | ------------ |
| `input`  | object | **Required** |
| `output` | object | **Required** |

#### input

`input`

- is **required**
- type: `object`

##### input Type

`object` with following properties:

| Property | Type    | Required     |
| -------- | ------- | ------------ |
| `line`   | integer | **Required** |
| `reset`  | boolean | **Required** |

#### line

`line`

- is **required**
- type: `integer`

##### line Type

`integer`

- minimum value: `0`
- maximum value: `5`

#### reset

`reset`

- is **required**
- type: `boolean`

##### reset Type

`boolean`

### Ubus CLI Example

```
ubus call endpt rtp_stats {"line":0,"reset":true}
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": ["<SID>", "endpt", "rtp_stats", { "line": 0, "reset": true }]
}
```

#### output

`output`

- is **required**
- type: `object`

##### output Type

`object` with following properties:

| Property                | Type    | Required     |
| ----------------------- | ------- | ------------ |
| `discarded`             | integer | **Required** |
| `jbAvg`                 | integer | **Required** |
| `jitter`                | integer | **Required** |
| `lineId`                | integer | **Required** |
| `localBurstDensity`     | integer | **Required** |
| `localBurstDuration`    | integer | **Required** |
| `localGapDensity`       | integer | **Required** |
| `localGapDuration`      | integer | **Required** |
| `localJbAbsMax`         | integer | **Required** |
| `localJbMax`            | integer | **Required** |
| `localJbNominal`        | integer | **Required** |
| `localJbRate`           | integer | **Required** |
| `lost`                  | integer | **Required** |
| `maxJitter`             | integer | **Required** |
| `remoteBurstDensity`    | integer | **Required** |
| `remoteBurstDuration`   | integer | **Required** |
| `remoteGapDensity`      | integer | **Required** |
| `remoteGapDuration`     | integer | **Required** |
| `remoteJbAbsMax`        | integer | **Required** |
| `remoteJbMax`           | integer | **Required** |
| `remoteJbNominal`       | integer | **Required** |
| `remoteJbRate`          | integer | **Required** |
| `rxpkts`                | integer | **Required** |
| `txpkts`                | integer | **Required** |
| `uLossRate`             | integer | **Required** |

#### discarded

`discarded`

- is **required**
- type: `integer`

##### discarded Type

`integer`

- minimum value: `0`

#### jbAvg

`jbAvg`

- is **required**
- type: `integer`

##### jbAvg Type

`integer`

- minimum value: `0`

#### jitter

`jitter`

- is **required**
- type: `integer`

##### jitter Type

`integer`

- minimum value: `0`

#### lineId

`lineId`

- is **required**
- type: `integer`

##### lineId Type

`integer`

- minimum value: `0`
- maximum value: `5`

#### localBurstDensity

`localBurstDensity`

- is **required**
- type: `integer`

##### localBurstDensity Type

`integer`

- minimum value: `0`

#### localBurstDuration

`localBurstDuration`

- is **required**
- type: `integer`

##### localBurstDuration Type

`integer`

- minimum value: `0`

#### localGapDensity

`localGapDensity`

- is **required**
- type: `integer`

##### localGapDensity Type

`integer`

- minimum value: `0`

#### localGapDuration

`localGapDuration`

- is **required**
- type: `integer`

##### localGapDuration Type

`integer`

- minimum value: `0`

#### localJbAbsMax

`localJbAbsMax`

- is **required**
- type: `integer`

##### localJbAbsMax Type

`integer`

- minimum value: `0`

#### localJbMax

`localJbMax`

- is **required**
- type: `integer`

##### localJbMax Type

`integer`

- minimum value: `0`

#### localJbNominal

`localJbNominal`

- is **required**
- type: `integer`

##### localJbNominal Type

`integer`

- minimum value: `0`

#### localJbRate

`localJbRate`

- is **required**
- type: `integer`

##### localJbRate Type

`integer`

- minimum value: `0`

#### lost

`lost`

- is **required**
- type: `integer`

##### lost Type

`integer`

- minimum value: `0`

#### maxJitter

`maxJitter`

- is **required**
- type: `integer`

##### maxJitter Type

`integer`

- minimum value: `0`

#### remoteBurstDensity

`remoteBurstDensity`

- is **required**
- type: `integer`

##### remoteBurstDensity Type

`integer`

- minimum value: `0`

#### remoteBurstDuration

`remoteBurstDuration`

- is **required**
- type: `integer`

##### remoteBurstDuration Type

`integer`

- minimum value: `0`

#### remoteGapDensity

`remoteGapDensity`

- is **required**
- type: `integer`

##### remoteGapDensity Type

`integer`

- minimum value: `0`

#### remoteGapDuration

`remoteGapDuration`

- is **required**
- type: `integer`

##### remoteGapDuration Type

`integer`

- minimum value: `0`

#### remoteJbAbsMax

`remoteJbAbsMax`

- is **required**
- type: `integer`

##### remoteJbAbsMax Type

`integer`

- minimum value: `0`

#### remoteJbMax

`remoteJbMax`

- is **required**
- type: `integer`

##### remoteJbMax Type

`integer`

- minimum value: `0`

#### remoteJbNominal

`remoteJbNominal`

- is **required**
- type: `integer`

##### remoteJbNominal Type

`integer`

- minimum value: `0`

#### remoteJbRate

`remoteJbRate`

- is **required**
- type: `integer`

##### remoteJbRate Type

`integer`

- minimum value: `0`

#### rxpkts

`rxpkts`

- is **required**
- type: `integer`

##### rxpkts Type

`integer`

- minimum value: `0`

#### txpkts

`txpkts`

- is **required**
- type: `integer`

##### txpkts Type

`integer`

- minimum value: `0`

#### uLossRate

`uLossRate`

- is **required**
- type: `integer`

##### uLossRate Type

`integer`

- minimum value: `0`

### Output Example

```json
{
  "lineId": 3,
  "localBurstDensity": 72187314,
  "remoteBurstDensity": 57272242,
  "localBurstDuration": 550512,
  "remoteBurstDuration": 9577445,
  "localGapDensity": 31746248,
  "remoteGapDensity": 5373655,
  "localGapDuration": 93046060,
  "remoteGapDuration": 6028757,
  "localJbRate": 48187376,
  "remoteJbRate": 42684338,
  "localJbMax": 4617104,
  "remoteJbMax": 68868842,
  "localJbNominal": 97005535,
  "remoteJbNominal": 37554392,
  "localJbAbsMax": 15660701,
  "remoteJbAbsMax": 15370482,
  "discarded": 38026287,
  "lost": 73256347,
  "rxpkts": 77415865,
  "txpkts": 30316611,
  "jbAvg": 16648797,
  "jitter": 12286104,
  "uLossRate": 44899753,
  "maxJitter": 68636630,
}
```

## signal

`signal`

- type: `Method`

### signal Type

`object` with following properties:

| Property | Type   | Required     |
| -------- | ------ | ------------ |
| `input`  | object | **Required** |
| `output` | object | Optional     |

#### input

`input`

- is **required**
- type: `object`

##### input Type

`object` with following properties:

| Property | Type    | Required     |
| -------- | ------- | ------------ |
| `data`   | string  | Optional     |
| `line`   | integer | **Required** |
| `signal` | string  | **Required** |
| `state`  | string  | **Required** |

#### data

`data`

- is optional
- type: `string`

##### data Type

`string`

#### line

`line`

- is **required**
- type: `integer`

##### line Type

`integer`

- minimum value: `0`
- maximum value: `5`

#### signal

`signal`

- is **required**
- type: `enum`

##### signal Type

`string`

The value of this property **must** be equal to one of the [known values below](#signal-known-values).

##### signal Known Values

| Value          |
| -------------- |
| dial           |
| ringback       |
| stutter        |
| unobtainable   |
| callwt         |
| busy           |
| ringing        |
| callid_ringing |
| callid         |
| congestion     |
| dial2          |
| dtmf0          |
| dtmf1          |
| dtmf2          |
| dtmf3          |
| dtmf4          |
| dtmf5          |
| dtmf6          |
| dtmf7          |
| dtmf8          |
| dtmf9          |
| dtmf\*         |
| dtmf#          |

#### state

`state`

- is **required**
- type: `enum`

##### state Type

`string`

The value of this property **must** be equal to one of the [known values below](#signal-known-values).

##### state Known Values

| Value |
| ----- |
| on    |
| off   |

### Ubus CLI Example

```
ubus call endpt signal {"line":0,"signal":"busy","state":"on","data":"dolor"}
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": ["<SID>", "endpt", "signal", { "line": 0, "signal": "busy", "state": "on", "data": "dolor" }]
}
```

#### output

`output`

- is optional
- type: `object`

##### output Type

`object` with following properties:

| Property | Type | Required |
| -------- | ---- | -------- |
| None     | None | None     |

### Output Example

```json
{}
```

## status

`status`

- type: `Method`

### status Type

`object` with following properties:

| Property | Type   | Required     |
| -------- | ------ | ------------ |
| `input`  | object | **Required** |
| `output` | object | **Required** |

#### input

`input`

- is **required**
- type: `object`

##### input Type

`object` with following properties:

| Property | Type    | Required     |
| -------- | ------- | ------------ |
| `line`   | integer | **Required** |

#### line

`line`

- is **required**
- type: `integer`

##### line Type

`integer`

- minimum value: `0`
- maximum value: `5`

### Ubus CLI Example

```
ubus call endpt status {"line":1}
```

### JSONRPC Example

```json
{ "jsonrpc": "2.0", "id": 0, "method": "call", "params": ["<SID>", "endpt", "status", { "line": 1 }] }
```

#### output

`output`

- is **required**
- type: `object`

##### output Type

`object` with following properties:

| Property  | Type    | Required     |
| --------- | ------- | ------------ |
| `line`    | integer | **Required** |
| `offhook` | integer | **Required** |

#### line

`line`

- is **required**
- type: `integer`

##### line Type

`integer`

- minimum value: `0`
- maximum value: `5`

#### offhook

`offhook`

- is **required**
- type: `enum`

##### offhook Type

`integer`

The value of this property **must** be equal to one of the [known values below](#status-known-values).

##### offhook Known Values

| Value |
| ----- |
| 0     |
| 1     |

### Output Example

```json
{ "line": 3, "offhook": 1 }
```
