#ifndef __VOICEMNGR_UBUS_H
#define __VOICEMNGR_UBUS_H

#include <time.h>
#include <libubus.h>
#include <uci.h>

#include "line.h"

#define UBUS_REQUEST_TIMEOUT   2

extern const char uciStrConfig[];

int ubus_call_asterisk(const struct line_event_t* const ev);
int ubus_broadcast_event(const struct line_event_t* const ev);
int send_reply_asterisk(struct voice_ubus_req_t *req, enum ubus_msg_status ubusRet);
int send_reply_dectmngr(struct voice_ubus_req_t *req, int terminal, int pcmId, enum ubus_msg_status ubusRet);
int ubus_call_dectmngr(int terminal, int add, int release, const char *cid, const char *caller_name, int pcmId, struct line_req_t *lineReq);
int ubus_dectmngr_rpc(const struct dectmngr_rpc_t *dectmngr_rpc, const struct line_req_t *line_req);
int config_init(struct uci_context *context, struct uci_package *package);
void config_syslog(struct uci_context *context, struct uci_package *package);
int ubus_disable_receive(void);
int ubus_enable_receive(void);
int ubus_init(void);
int ubus_close(void);

#endif
