#ifndef __VOICEMNGR_LINE_H
#define __VOICEMNGR_LINE_H

#include <stdint.h>
#include <libubus.h>

#include <libpicoevent.h>

// In UBUS request to dectmngr we need to define what this request is about
enum line_action_t {
	ACTION_CONN_CREATE,
	ACTION_CONN_CLOSE,
	ACTION_SIG_RING,
	ACTION_SIG_ANSWERED,
	ACTION_SIG_BUSY_TONE,
	ACTION_SIG_CW_CLOSE,
	ACTION_CALL_MISSED,
	ACTION_RINGING_STOP
};

// Event sent with UBUS when something has happened with a phone line
struct line_event_t {
	const char *name; // String communicated with Asterisk
	int data;         // True/false is a DTMF button is pressed/depressed
	int line;         // Line number
};

// Deferred UBUS request
struct voice_ubus_req_t {
	struct ubus_context *ctx;
	struct timespec timeStamp;        // Time stamp of input request
	struct ubus_request_data *reqIn;  // Received input request
	struct ubus_request_data reqOut;  // Sent output request
};

// Deferred line request (for UBUS communication)
struct line_req_t {
	int line;
	int pcm_id;
	int connection_id;                 // Connection ID from Asterisk
	enum line_action_t action;         // The requested action from origin
	char caller_id[MAX_CALLER_ID_LEN]; // Caller ID
	char caller_name[MAX_CALLER_NAME]; // Caller Name
	struct voice_ubus_req_t ubus;
	struct timespec time_stamp;
};

struct dectmngr_rpc_t {
	enum line_action_t action;
	int  extension_id;
	int  pcm_id;
	union {
		// Action specific parameters will be added here
	} params;
};

int find_endpt_from_asterisk_id(int line);
int line_new_connection_by_asterisk(int line, int connection, struct voice_ubus_req_t *ubus_req);
int line_close_connection_by_asterisk(int line, int connection, struct voice_ubus_req_t *ubus_req);
int line_release_connection_by_asterisk(int line, int connection, struct voice_ubus_req_t *ubus_req);
int line_update_connection_by_pbx(int line, int pcm_callid);
int line_new_connection_by_dect(int line, const char *cid, int pcm, struct voice_ubus_req_t *ubus_req);
int line_connection_parm_update_by_asterisk(int line, int connection, struct config_update_struct *data);
int line_close_connection_by_dect(int line, int pcm, struct voice_ubus_req_t *ubus_req);
int line_signal(int line, const char *signame, const char *data, struct voice_ubus_req_t *ubus_req);
void pcm_states_dump(const char* func, int line);
callid_state get_callid_state(int call_id);

#endif
