import { uniq, searchAll } from "../util.js";
const decode = (msg) => {
const affectedPaths = searchAll(msg, "affectedPaths") || [];
return [affectedPaths];
};
const encode = ({ paths, allowPartial }) => ({
lookup: "Msg",
header: {
msgId: uniq("DELETE@"),
msgType: "DELETE",
lookup: "Header",
},
body: {
lookup: "Body",
request: {
lookup: "Request",
delete: {
objPaths: Array.isArray(paths) ? paths : [paths],
allowPartial: (allowPartial !== undefined) ? allowPartial : true,
},
},
},
});
export default {
decode,
encode
};
