import { searchAll } from "../util.js";
import * as util from "../util.js";
import { parseSetArgs } from "../../util.js";
const decode = (msg, decodeOptions) => {
if (decodeOptions?.raw)
return [msg];
const affected = searchAll(msg, "updatedInstResults");
return [affected];
};
const isObject = (v) => typeof v === "object" && v.required !== undefined && v.value !== undefined;
const makePairs = (path, value) => path.endsWith(".") && typeof value === "object" && value !== null
? Object.entries(value).map(([k, v]) => isObject(v)
? [k, v.value.toString(), "required" in v && Boolean(v.required)]
: [k, v.toString(), true])
: [[path.split(".").pop() || "", (value || "").toString(), true]];
const encode = ({ value, path: initialPath }) => {
const [paths, values] = parseSetArgs(value, initialPath);
const allowPartial = (values && values.some((it) => (it.allowPartial !== undefined) ? it.allowPartial : true));
const updateObjs = paths.map((path, i) => ({
lookup: "Set.UpdateObject",
objPath: path.endsWith(".")
? path
: path.slice(0, path.lastIndexOf(".") + 1),
paramSettings: makePairs(path, values[i])
.filter(([k]) => k !== "allowPartial")
.map(([param, value, required]) => ({
lookup: "Set.UpdateParamSetting",
param,
value,
required,
})),
}));
return {
lookup: "Msg",
header: {
lookup: "Header",
msgId: util.uniq("SET@"),
msgType: "SET",
},
body: {
lookup: "Body",
request: {
lookup: "Request",
set: {
allowPartial,
updateObjs,
},
},
},
};
};
export default {
decode,
encode,
};
