import * as util from "../util.js";
const decode = (msg) => {
const data = util.searchAll(msg, "operationResults");
const output = util.search(data, 'reqOutputArgs');
if (output)
return [output];
if (data && data.length === 1)
return [util.unflatten(data[0])];
const unflattened = data.map((v) => util.unflatten(v));
return [unflattened];
};
const encode = ({ path, input, id, resp, commandKey }) => ({
lookup: "Msg",
header: {
msgId: id,
msgType: "OPERATE",
lookup: "Header",
},
body: {
lookup: "Body",
request: {
lookup: "Request",
operate: {
command: path,
commandKey: commandKey || "",
sendResp: resp,
inputArgs: input || {},
},
},
},
});
export default {
decode,
encode
};
