export default {
    nested: {
        usp_record: {
            nested: {
                Record: {
                    oneofs: {
                        recordType: {
                            oneof: [
                                "noSessionContext",
                                "sessionContext",
                                "websocketConnect",
                                "mqttConnect",
                                "stompConnect",
                                "disconnect",
                            ],
                        },
                    },
                    fields: {
                        version: { type: "string", id: 1 },
                        toId: { type: "string", id: 2 },
                        fromId: { type: "string", id: 3 },
                        payloadSecurity: { type: "PayloadSecurity", id: 4 },
                        macSignature: { type: "bytes", id: 5 },
                        senderCert: { type: "bytes", id: 6 },
                        noSessionContext: { type: "NoSessionContextRecord", id: 7 },
                        sessionContext: { type: "SessionContextRecord", id: 8 },
                        websocketConnect: { type: "WebSocketConnectRecord", id: 9 },
                        mqttConnect: { type: "MQTTConnectRecord", id: 10 },
                        stompConnect: { type: "STOMPConnectRecord", id: 11 },
                        disconnect: { type: "DisconnectRecord", id: 12 },
                    },
                    nested: { PayloadSecurity: { values: { PLAINTEXT: 0, TLS12: 1 } } },
                },
                NoSessionContextRecord: {
                    fields: { payload: { type: "bytes", id: 2 } },
                },
                SessionContextRecord: {
                    fields: {
                        sessionId: { type: "uint64", id: 1 },
                        sequenceId: { type: "uint64", id: 2 },
                        expectedId: { type: "uint64", id: 3 },
                        retransmitId: { type: "uint64", id: 4 },
                        payloadSarState: { type: "PayloadSARState", id: 5 },
                        payloadrecSarState: { type: "PayloadSARState", id: 6 },
                        payload: { rule: "repeated", type: "bytes", id: 7 },
                    },
                    nested: {
                        PayloadSARState: {
                            values: { NONE: 0, BEGIN: 1, INPROCESS: 2, COMPLETE: 3 },
                        },
                    },
                },
                WebSocketConnectRecord: { fields: {} },
                MQTTConnectRecord: {
                    fields: {
                        version: { type: "MQTTVersion", id: 1 },
                        subscribedTopic: { type: "string", id: 2 },
                    },
                    nested: { MQTTVersion: { values: { V3_1_1: 0, V5: 1 } } },
                },
                STOMPConnectRecord: {
                    fields: {
                        version: { type: "STOMPVersion", id: 1 },
                        subscribedDestination: { type: "string", id: 2 },
                    },
                    nested: { STOMPVersion: { values: { V1_2: 0 } } },
                },
                DisconnectRecord: {
                    fields: {
                        reason: { type: "string", id: 1 },
                        reasonCode: { type: "fixed32", id: 2 },
                    },
                },
            },
        },
    },
};
