import { client as WebSocketClient } from "websocket";
import { decodeId } from "../commands/index.js";
import buildConnect from "./build.js";
import protobuf from "protobufjs";
import rootRecordJson from "../specs/usp-record-1-1.js";
import rootMsgJson from "../specs/usp-msg-1-1.js";
const connectClient = (opts) => new Promise((resolve, reject) => {
const client = new WebSocketClient();
client.on("connectFailed", (error) => {
reject(error);
});
client.on("connect", (ws) => {
resolve({
on: (key, responseFn) => ws.on(key, (data) => responseFn(key, data)),
subscribe: (to) => null,
unsubscribe: (from) => null,
publish: (endpoint, msg) => ws.send(msg),
end: ws.close,
});
});
client.connect(`${opts.protocol}://${opts.host}:${opts.port}/usp/endpoint`, "v1.usp");
});
const loadProtobuf = async (version) => {
const rootRecord = protobuf.Root.fromJSON(rootRecordJson);
const rootMsg = protobuf.Root.fromJSON(rootMsgJson);
const header = rootMsg.lookupType("usp.Header");
return { rootRecord, rootMsg, header };
};
export default buildConnect({
connectClient,
decodeID: decodeId,
loadProtobuf,
});
