import { search, uniq } from "../util.js";
const subscriptionPath = "Device.LocalAgent.Subscription.";
const make = (call, on) => async (opts, callback) => {
const id = "NOTIFY@" + (opts.id || uniq());
const refList = Array.isArray(opts.reference)
? opts.reference.join(",")
: opts.reference;
const newSubPath = await call("ADD", {
path: subscriptionPath,
value: {
Enable: opts.enable ?? true,
ID: id,
NotifType: opts.notif,
NotifRetry: opts.retry ?? true,
ReferenceList: refList,
Persistent: opts.persist ?? false,
},
});
// from https://usp.technology/specification/07-index-messages.html#sec:responses-and-retry
const respond = (msgId) => call("NOTIFY_RESP", { subscriptionId: id, msgId });
const clear = on(id, (msg, fullMsg, opts) => {
opts?.sendResp && respond(search(fullMsg, "msgId"));
callback(msg, fullMsg);
});
return () => {
clear();
return call("DELETE", { paths: newSubPath });
};
};
export default {
name: "subscribe",
make,
};
