import buildConnect from "../build.js";
import rootRecordJson from "../../specs/usp-record-1-2.js";
import rootMsgJson from "../../specs/usp-msg-1-2.js";
import mqttAsync from "./async-mqtt.js";
const generateRandomClientId = () => "qjs_" + Math.random().toString(16).substr(2, 8);
const connectClient = async (options) => await mqttAsync.connectAsync(options.host, options.port, options.username, options.password, options.clientId || generateRandomClientId());
const loadProtobuf = async () => {
const rootRecord = protobuf.Root.fromJSON(rootRecordJson);
const rootMsg = protobuf.Root.fromJSON(rootMsgJson);
const header = rootMsg.lookupType("usp.Header");
return { rootRecord, rootMsg, header };
};
function decodeId(array) {
var out, i, len, c;
var char2, char3;
out = "";
len = array.length;
i = 0;
while (i < len) {
c = array[i++];
switch (c >> 4) {
case 0:
case 1:
case 2:
case 3:
case 4:
case 5:
case 6:
case 7:
// 0xxxxxxx
out += String.fromCharCode(c);
break;
case 12:
case 13:
// 110x xxxx   10xx xxxx
char2 = array[i++];
out += String.fromCharCode(((c & 0x1f) << 6) | (char2 & 0x3f));
break;
case 14:
// 1110 xxxx  10xx xxxx  10xx xxxx
char2 = array[i++];
char3 = array[i++];
out += String.fromCharCode(((c & 0x0f) << 12) | ((char2 & 0x3f) << 6) | ((char3 & 0x3f) << 0));
break;
}
}
return out;
}
export default buildConnect({
connectClient,
decodeID: decodeId,
loadProtobuf,
});
