// import set from "lodash.set";
const digitDotRe = /^\d+\..*$/;
const digitRe = /^\d+$/;
export const isDigit = (v) => digitRe.test(v);
const firstIsIndex = (s) => digitDotRe.test(s);
// based on https://stackoverflow.com/questions/54733539/javascript-implementation-of-lodash-set-method
const isIndexToken = (v) => typeof v === "number" ||
    (typeof v === "string" && v.length > 0 && digitRe.test(v));
const set = (obj, path, value) => {
    if (Object(obj) !== obj)
        return obj;
    const parts = Array.isArray(path)
        ? path
        : path
            ? path.toString().match(/[^.[\]]+/g) || []
            : [];
    if (parts.length === 0)
        return obj;
    let cur = obj;
    for (let i = 0; i < parts.length - 1; i++) {
        const key = parts[i];
        const nextKey = parts[i + 1];
        const existing = cur[key];
        if (existing !== null && existing !== undefined && typeof existing === "object") {
            cur = existing;
            continue;
        }
        const child = isIndexToken(nextKey) ? [] : {};
        cur[key] = child;
        cur = child;
    }
    cur[parts[parts.length - 1]] = value;
    return obj;
};
// Based on: https://www.30secondsofcode.org/js/s/unflatten-object
export const unflatten = (obj) => Object.keys(obj).reduce((res, k) => {
    k.split(".")
        .map((v) => (isDigit(v) ? parseInt(v) - 1 : v))
        .reduce((acc, e, i, keys) => acc[e] ||
        (acc[e] = isNaN(Number(keys[i + 1]))
            ? keys.length - 1 === i
                ? obj[k]
                : {}
            : []), res);
    return res;
}, firstIsIndex(Object.keys(obj)[0]) ? [] : {});
export const search = (obj, key) => {
    if (typeof obj !== "object")
        return null;
    if (obj[key])
        return obj[key];
    for (const val of Object.values(obj)) {
        const s = search(val, key);
        if (s)
            return s;
    }
};
export const searchParent = (obj, key) => {
    if (typeof obj !== "object")
        return;
    if (obj[key])
        return obj;
    for (const val of Object.values(obj)) {
        const s = searchParent(val, key);
        if (s)
            return s;
    }
};
const splitDotPath = (s) => s
    .split(".")
    .filter((it) => it !== "")
    .map((it) => (isDigit(it) ? parseInt(it, 10) - 1 : it));
const getOrCreateAtPath = (root, parts) => {
    let cur = root;
    for (let i = 0; i < parts.length; i++) {
        const key = parts[i];
        const nextKey = parts[i + 1];
        let child = cur[key];
        if (child === null || child === undefined || typeof child !== "object") {
            child = typeof nextKey === "number" ? [] : {};
            cur[key] = child;
        }
        cur = child;
    }
    return cur;
};
export const convertToNestedObject = (arr) => {
    // Performance note:
    // The previous implementation built multiple large intermediate arrays and
    // performed a global sort over all param paths. For big GET responses this
    // is extremely slow in constrained runtimes (e.g. QuickJS on OpenWrt).
    //
    // This implementation avoids intermediate allocations and sorting.
    const res = {};
    for (const it of arr) {
        const resolvedPath = it && typeof it.resolvedPath === "string" ? it.resolvedPath : "";
        const params = it && typeof it.resultParams === "object" && it.resultParams
            ? it.resultParams
            : {};
        const base = getOrCreateAtPath(res, splitDotPath(resolvedPath));
        for (const [key, value] of Object.entries(params)) {
            // The common case is a simple param name (no nesting); assign directly.
            if (typeof key === "string" && key.includes("."))
                set(base, key, value);
            else
                base[key] = value;
        }
    }
    return res;
};
export const hasMultipleIndexes = (arr, pathSplit) => arr.some((it) => {
    const spl = it.split(".");
    return spl.length > pathSplit.length && isDigit(spl[pathSplit.length - 1]);
});
const _searchAll = (obj, key) => typeof obj !== "object"
    ? []
    : Object.entries(obj).reduce((acc, [k, v]) => [...acc, k === key ? v : _searchAll(v, key)], []);
export const searchAll = (obj, key) => _searchAll(obj, key).flat(Infinity);
export const extractCommand = (msg) => {
    const msgType = search(msg, "msgType");
    if (!msgType) {
        const id = search(msg, "msgId");
        const [frst] = id ? id.split("@") : [""];
        return frst.toUpperCase().replace("_RESP", "");
    }
    return msgType.replace("_RESP", "");
};
/** Unwraps object with single key */
export const unwrapObject = (data) => !Array.isArray(data) &&
    typeof data === "object" &&
    Object.keys(data).length === 1
    ? Object.values(data)[0]
    : data;
/** Unwraps array with single item */
export const unwrapArray = (arr) => Array.isArray(arr) && arr.length === 1 ? arr[0] : arr;
export const isEmptyObject = (obj) => obj !== null &&
    obj !== undefined &&
    obj &&
    typeof obj === "object" &&
    Object.keys(obj).length === 0;
export const isEmpty = (v) => isEmptyObject(v);
export function makeBuffer(rootRecord, payload, version, options, sessionOptions, useSession) {
    const contextRecord = rootRecord.lookupType(`usp_record.${useSession ? "" : "No"}SessionContextRecord`);
    const contextRecordMsg = contextRecord.create({
        payload: useSession ? [payload] : payload,
        ...(useSession ? sessionOptions : {}),
    });
    const record = rootRecord.lookupType("usp_record.Record");
    const recordMsg = record.create({
        version,
        PayloadSecurity: record.PayloadSecurity.PLAINTEXT,
        ...(useSession
            ? { sessionContext: contextRecordMsg }
            : { noSessionContext: contextRecordMsg }),
        ...options,
    });
    const buffer = record.encode(recordMsg).finish();
    return buffer;
}
export const uniq = (initial) => (initial || "") +
    (Date.now().toString(36) + Math.random().toString(36).substr(2, 5)).toUpperCase();
export const parseID = (msg) => {
    const foundId = search(msg, "msgId");
    // if id is formatted by me (command@) then use, otherwise check for sub id
    const id = foundId.includes("@")
        ? foundId
        : search(msg, "subscriptionId") || null;
    return id;
};
const grab = (item, key) => Array.isArray(item)
    ? isDigit(key)
        ? item.find((val) => val !== null && val !== undefined)
        : item
    : key === "-1"
        ? item.find((v) => v !== null)
        : item[key];
const skipKeys = (obj, keys) => keys.length === 1
    ? grab(obj, keys[0])
    : skipKeys(grab(obj, keys[0]), keys.slice(1));
const removeNulls = (obj) => {
    if (obj === null || obj === undefined)
        return obj;
    if (typeof obj !== "object")
        return obj;
    if (Array.isArray(obj)) {
        const out = [];
        for (const v of obj) {
            if (v === null)
                continue;
            out.push(removeNulls(v));
        }
        return out;
    }
    const out = {};
    for (const [key, value] of Object.entries(obj)) {
        out[key] = removeNulls(value);
    }
    return out;
};
const pathJoin = (a, b) => a.endsWith(".") ? a + b : a + "." + b;
const addQueries = (obj, path) => {
    if (obj === null || obj === undefined)
        return obj;
    if (typeof obj !== "object")
        return obj;
    if (Array.isArray(obj)) {
        const out = [];
        for (let i = 0; i < obj.length; i++) {
            const v = obj[i];
            if (v === null)
                continue;
            out.push(addQueries(v, pathJoin(path, (i + 1).toString()) + "."));
        }
        return out;
    }
    const out = { __query__: path };
    for (const [key, val] of Object.entries(obj)) {
        out[key] =
            val === null || typeof val !== "object"
                ? val
                : addQueries(val, pathJoin(path, key) + ".");
    }
    return out;
};
export const processGetResult = (reqPathResults, decodeOptions) => {
    const retainPath = decodeOptions?.retainPath === true;
    const results = reqPathResults.map((resolvedResult) => {
        const respType = determineResponseType(resolvedResult);
        if (resolvedResult.resolvedPathResults === undefined)
            return null;
        const results = resolvedResult.resolvedPathResults || [];
        if (respType === ResponseType.Property) {
            const result = Object.values(results[0].resultParams)[0];
            return !retainPath
                ? result
                : { __query__: resolvedResult.requestedPath, result };
        }
        if (respType === ResponseType.PropertyList) {
            const result = results.map((result) => Object.values(result.resultParams)[0]);
            return !retainPath
                ? result
                : {
                    __query__: resolvedResult.requestedPath,
                    result: result.map((str, i) => ({
                        __query__: results[i].resolvedPath +
                            Object.keys(results[i].resultParams)[0],
                        result: str,
                    })),
                };
        }
        if (respType === ResponseType.Object ||
            respType === ResponseType.ObjectList) {
            const path = resolvedResult.requestedPath;
            const resolvedPath = findResolvedPath(path, results[0].resolvedPath);
            const keys = resolvedPath.split(".").slice(0, -1);
            const nestedObject = convertToNestedObject(results);
            const mainObject = skipKeys(nestedObject, keys);
            const cleanedObject = removeNulls(mainObject);
            return !retainPath
                ? cleanedObject
                : {
                    __query__: path,
                    result: addQueries(mainObject, resolvedPath),
                };
        }
        return null;
    });
    return results.length === 1 ? results[0] : results;
};
const findResolvedPath = (requestedPath, resolvedPath) => resolvedPath.substring(0, requestedPath.length);
export var ResponseType;
(function (ResponseType) {
    ResponseType["Property"] = "Property";
    ResponseType["PropertyList"] = "PropertyList";
    ResponseType["Object"] = "Object";
    ResponseType["ObjectList"] = "ObjectList";
})(ResponseType || (ResponseType = {}));
const containsQuery = (path) => path.split(".").some((part) => part.includes("*") || part.includes("["));
const endsWithProperty = (path) => /^.+\.[A-Za-z0-9_]+$/.test(path);
const endsWithIndex = (path) => /^.+\.\d+\.$/.test(path);
const endsWithIndexedProperty = (path) => /^.+\.\d+\..+$/.test(path.split(".").slice(-2)[0]);
const containsIndexes = (pathResult) => pathResult.resolvedPathResults === undefined
    ? false
    : pathResult.resolvedPathResults.some(({ resolvedPath, resultParams }) => (endsWithIndex(resolvedPath) &&
        resolvedPath.split(".").length ===
            pathResult.requestedPath.split(".").length + 1) ||
        Object.keys(resultParams).some((key) => endsWithIndexedProperty(pathResult.requestedPath + key)));
const determineResponseType = (pathResult) => {
    const isQuery = containsQuery(pathResult.requestedPath);
    if (endsWithProperty(pathResult.requestedPath))
        return isQuery ? ResponseType.PropertyList : ResponseType.Property;
    if (isQuery || containsIndexes(pathResult))
        return ResponseType.ObjectList;
    if (endsWithIndex(pathResult.requestedPath))
        return ResponseType.Object;
    return ResponseType.Object;
};
