const splitReference = (s) => s.split(",");
const isReference = (s) => s.startsWith("Device.");
const addDot = (s) => (s.endsWith(".") ? s : s + ".");
const resolveReferences = async (message, call, level) => {
    if (level === 0 || !["string", "object"].includes(typeof message))
        return message;
    if (typeof message === "string") {
        const msg = await call("GET", { paths: splitReference(message).map(addDot) }).catch(() => message);
        return await resolveReferences(msg, call, level - 1);
    }
    else if (typeof message === "object") {
        const msg = Array.isArray(message) ? [...message] : { ...message };
        for (const [key, val] of Object.entries(message)) {
            if (typeof val === "string" && isReference(val)) {
                const item = await call("GET", { paths: splitReference(val).map(addDot) }).catch(() => val);
                msg[key] = await resolveReferences(item, call, level - 1);
            }
            else if (typeof val === "object")
                msg[key] = await resolveReferences(msg[key], call, level);
        }
        return msg;
    }
    return message;
};
const make = (call) => (msg, level) => resolveReferences(msg, call, level || 1);
export default {
    name: "resolve",
    make
};
