import * as util from "../util.js";
const decode = (msg, decodeOptions) => {
const reqPathResults = util.search(msg, "reqPathResults");
if (decodeOptions?.raw)
return [reqPathResults];
if (reqPathResults) {
return [
util.processGetResult(reqPathResults, decodeOptions),
];
}
return [null];
};
const encode = ({ paths, options }) => ({
lookup: "Msg",
header: {
msgId: util.uniq("GET@"),
msgType: "GET",
lookup: "Header",
},
body: {
lookup: "Body",
request: {
lookup: "Request",
get: {
paramPaths: Array.isArray(paths) ? paths : [paths],
...(Number.isInteger(options?.max_depth)
? { maxDepth: options.max_depth }
: {}),
},
},
},
});
export default {
decode,
encode,
};
