import * as util from "../util.js";
import { parseSetArgs } from "../../util.js";
const decode = (msg) => {
const paths = util.searchAll(msg, "instantiatedPath");
if (paths && paths.length === 1)
return [paths[0]];
return [paths];
};
const isObj = (v) => typeof v === "object" && v.required !== undefined && v.value !== undefined;
const makePair = (value) => value
? Object.entries(value).map(([k, v]) => isObj(v)
? [k, v.value.toString(), "required" in v && Boolean(v.required)]
: [k, v.toString(), true])
: [];
const encode = ({ value, path }) => {
const [paths, values] = parseSetArgs(value, path);
const allowPartial = (values && values.some((it) => (it.allowPartial !== undefined) ? it.allowPartial : true));
const createObjs = paths.map((path, i) => ({
lookup: "Add.CreateObject",
objPath: path,
paramSettings: makePair(values[i])
.filter(([k]) => k !== "allowPartial")
.map(([param, value, required]) => ({
lookup: "Add.CreateParamSetting",
param,
value,
required,
})),
}));
return {
lookup: "Msg",
header: {
lookup: "Header",
msgId: util.uniq("ADD@"),
msgType: "ADD",
},
body: {
lookup: "Body",
request: {
lookup: "Request",
add: {
allowPartial,
createObjs,
},
},
},
};
};
export default {
decode,
encode,
};
