import { uniq } from "../util.js";
const operateSubscriptionPath = "Device.LocalAgent.Subscription.";
const make = (call, on) => async (path, opts) => {
const Persistent = opts?.Persistent === undefined ? false : opts.Persistent;
const isAsync = !(opts && opts.isAsync === false);
const id = (isAsync ? "NOTIFY@" : "OPERATE@") + (opts?.ID || uniq(path));
const operateInput = {
Enable: true,
ID: id,
NotifType: "OperationComplete",
ReferenceList: path,
Persistent,
};
const commandKey = opts?.commandKey || "";
const command = (input) => {
return call("OPERATE", {
path,
input,
id,
resp: opts?.sendResponse ?? true,
commandKey,
}, isAsync ? { responseMsgType: "NOTIFY" } : {});
};
command.subscribe = (cb, opts) => {
const skipOperateResponse = opts?.skipOperateResponse ?? true;
const handleCallback = (msg) => {
if (skipOperateResponse &&
typeof msg === "object" &&
"executedCommand" in msg)
return;
else
cb(msg);
};
on(id, handleCallback);
return {
trigger: command,
};
};
if (isAsync) {
const newSubPath = await call("ADD", {
path: operateSubscriptionPath,
value: operateInput,
});
const cleanup = () => call("DELETE", { paths: newSubPath });
return [command, cleanup];
}
else
return [command, () => Promise.resolve()];
};
export default {
name: "operate",
make,
};
