import * as util from "../util.js";
const isArray = (it) => Array.isArray(it);
const isObject = (it) => typeof it === "object" && !isArray(it);
const fixObject = (obj) => {
if (!isObject(obj))
return obj;
const keys = Object.keys(obj);
if (keys.includes("supportedObjPath"))
return {
access: "OBJ_READ_ONLY",
...fillZeroParams(obj),
};
if (keys.includes("paramName"))
return {
access: "PARAM_READ_ONLY",
valueType: "PARAM_UNKNOWN",
valueChange: "VALUE_CHANGE_UNKNOWN",
...fillZeroParams(obj),
};
if (keys.includes("commandName"))
return { commandType: "CMD_UNKNOWN", ...fillZeroParams(obj) };
return fillZeroParams(obj);
};
const fillZeroParams = (obj) => {
if (!isObject(obj))
return obj;
return Object.entries(obj).reduce((acc, [key, value]) => ({
...acc,
[key]: isArray(value) ? value.map(fixObject) : fixObject(value),
}), {});
};
const decode = (msg) => {
const results = util.search(msg, "reqObjResults");
return [results.map(fillZeroParams)];
};
const encode = ({ paths, opts = {} }) => ({
lookup: "Msg",
header: {
msgId: util.uniq("GET_SUPPORTED_DM@"),
msgType: "GET_SUPPORTED_DM",
lookup: "Header",
},
body: {
lookup: "Body",
request: {
lookup: "Request",
getSupportedDm: {
objPaths: Array.isArray(paths) ? paths : [paths],
firstLevelOnly: opts.firstLevelOnly || false,
returnCommands: opts.returnCommands || false,
returnEvents: opts.returnEvents || false,
returnParams: opts.returnParams || false,
},
},
},
});
export default {
decode,
encode,
};
