import * as util from "../util.js";
const parseInfo = (key, data) => util.unflatten(util.search(data, key === "operComplete" ? "outputArgs" : key) || {});
const decode = (msg) => {
const parent = util.searchParent(msg, "subscriptionId");
if (parent) {
const id = parent.subscriptionId;
const relField = Object.keys(parent).find((k) => k !== "subscriptionId" && k !== "sendResp");
const err = util.search(msg, "cmdFailure");
return id && relField
? [parseInfo(relField, msg), id, err]
: [null, id, err];
}
return [null];
};
const encode = ({ sendResp, subscriptionId, ...rest }) => ({
lookup: "Msg",
header: {
msgId: util.uniq("NOTIFY@"),
msgType: "GET",
lookup: "Header",
},
body: {
lookup: "Body",
request: {
lookup: "Request",
notify: {
subscriptionId,
sendResp,
...rest,
},
},
},
});
export default {
decode,
encode,
};
