/*
 * helper.h: uci utilities
 *
 * Copyright (C) 2024 IOPSYS Software Solutions AB. All rights reserved.
 *
 * Author: Suvendhu Hansa <suvendhu.hansa@iopsys.eu>
 *
 * See LICENSE file for license related information.
 */

#ifndef __HELPER_H
#define __HELPER_H

#include <uci.h>

int usermgr_uci_init(const char *conf_path);
int usermgr_uci_fini(const char *package_name);

struct uci_section *usermgr_uci_add_section(const char *package, const char *section_type);
int usermgr_uci_delete_by_section(struct uci_section *section, const char *option, const char *value);

char *usermgr_uci_get_value_by_section(struct uci_section *section, const char *option);
char *usermgr_uci_set_value_by_section(struct uci_section *section, const char *option, const char *value);

struct uci_section *usermgr_uci_walk_section(const char *package, const char *section_type, struct uci_section *prev_section);

bool check_section_exist_by_option(const char *conf_path, const char *package, const char *section_type, const char *option, const char *val_check);
struct uci_section *get_section_from_config(const char *conf_path, const char *package, const char *section_type, const char *sec_name);

#define usermgr_uci_foreach_section(package, section_type, section) \
	for (section = usermgr_uci_walk_section(package, section_type, NULL); \
		section != NULL; \
		section = usermgr_uci_walk_section(package, section_type, section))


int add_user(const char *user_name);
int del_user(const char *user_name);
int enable_user(const char *user_name);
int disable_user(const char *user_name);
int change_username(const char *old_name, const char *new_name);
int change_password(const char *user_name, const char *password);
int configure_user_shell(const char *user_name, const char *shell);
int configure_user_group(const char *user_name, const char *group);
int add_group(const char *group_name);
int del_group(const char *group_name);
bool user_exist(char *user_name);
void strip_newline(char *str);
int validate_password_quality(const char *password, const char *min, const char *max);
#endif //__HELPER_H
