/*
 * Copyright (C) 2022 iopsys Software Solutions AB
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 2.1
 * as published by the Free Software Foundation
 *
 *      Author: Suvendhu Hansa <suvendhu.hansa@iopsys.eu>
 */

#ifndef _USERS_H
#define _USERS_H

#include <libbbfdm_api.h>
#include <libbbfdm-api/dmcommon.h>
#include <libubox/list.h>

#define GROUP_PREFIX "G_"
#define DMMAP_UCI_PATH "/etc/bbfdm/dmmap"
#define STD_UCI_PATH "/etc/config"

typedef struct global_node {
	struct list_head list;
	char name[70];
} g_node;

extern DMOBJ tUsersObj[];
extern DMOBJ tDeviceUsersObj[];
extern DMLEAF tUsersParams[];
extern DMLEAF tUsersUserParams[];
extern DMLEAF tUsersGroupParams[];
extern DMLEAF tUsersShellParams[];
extern DMLEAF tUsersRoleParams[];

#ifdef USERMNGR_ENABLE_VENDOR_EXT
extern DMOBJ tUsersAuthenticationObj[];
extern DMLEAF tUsersAuthenticationParams[];
extern DMLEAF tLockoutParams[];
extern DMLEAF tPasswordParams[];
#endif

#endif
