# Usermngr
User manager is a lightweight program to manage users, groups, supported shells and roles. It also provides the TR181 datamodel object `Device.Users.` using libbbf DotSO plugin.

## Configuration File

The `usermngr` UCI configuration is located in **'/etc/config/users'**, and contains 4 sections: **'user'**, **'group'**, **'role'** and **'shell'**.

```bash
config user 'admin'
        option enabled '1'
        option remote_access '1'

config user 'user'
        option enabled '1'
        option remote_access '1'

config shell
        option name 'ash'
        option enabled '1'

config user 'user_14'
        option enabled '0'
        option remote_access '0'
        option member_groups 'G_group_19'
        option member_roles 'Default_1'
        option shell 'ash'

config role 'role_1'
        option enabled '0'
        option role_id '2'
        option name 'Default_1'

config group 'G_group_19'
        option enabled '0'
        option member_roles 'Default_1'
```

> Note: To find more details about UCI parameters click [here](./docs/api/uci/usermngr.md) and for UCI raw schema click [here](./schema/uci.json)

## Dependencies

To successfully build usermngr, the following libraries are needed:

| Dependency    | Link                                        | License        |
| ------------  | ------------------------------------------- | -------------- |
| libuci        | https://git.openwrt.org/project/uci.git     | LGPL 2.1       |
| libbbfdm-api  | https://dev.iopsys.eu/bbf/bbfdm.git         | BSD-3          |


Runtime dependencies:

| Dependency  | Link                                        | License        |
| ----------- | ------------------------------------------- | -------------- |
| ubus        | https://git.openwrt.org/project/ubus.git    | LGPL 2.1       |
| bbfdm       | https://dev.iopsys.eu/iopsys/bbfdm.git      | BSD-3          |
| shadow-utils| https://git.openwrt.org/feed/packages.git   | BSD-3-Clause   |
