# USERINTERFACE

This package is responsible for providing the Device.UserInterface. datamodel object.

# Device.UserInterface.HTTPAccess
The backend of HTTPAccess datamodel has been implemented using nginx and nginx-util.
The parameters under `Device.UserInterface.` are mapped with the `userinterface` UCI parameters.

## Mapping between UCI and datamodel params
| Datamodel param                                         | UCI Section   | UCI param   |
|---------------------------------------------------------|---------------|-------------|
| Device.UserInerface.Enable                              | userinterface | enable      |
| Device.UserInterface.HTTPAccess.{i}.Port                | http_access   | port        |
| Device.UserInterface.HTTPAccess.{i}.AllowedPathPrefixes | http_access   | access_path |
| Device.UserInterface.HTTPAccess.{i}.AllowedHosts        | http_access   | allow_host  |
| Device.UserInterface.HTTPAccess.{i}.Enable              | http_access   | enable      |
| Device.UserInterface.HTTPAccess.{i}.AccessType          | http_access   | access      |
| Device.UserInterface.HTTPAccess.{i}.Interface           | http_access   | interface   |

## How to enable remote access of any server
To enable remote access of any server instance it is needed to set the `Device.UserInterface.HTTPAccess.{i}.AccessType` to `RemoteAccess`.
Along with the `AccessType` it is also required to set the `Device.UserInterface.HTTPAccess.{i}.Interface` with the specific `Device.IP.Interface.` instance on which the server will listen for remote connection.

## Port configuration
For port configuration it should be considered that each enabled server instance must have assigned a unique port number.
