/*
 * common.h: TWAMP utility functions
 *
 * Copyright (C) 2022, IOPSYS Software Solutions AB.
 *
 * Author: suvendhu.hansa@iopsys.eu
 *
 * See LICENSE file for license related information.
 *
 */

#ifndef _COMMON_H_
#define _COMMON_H_

#include "uci.h"
#include <syslog.h>

#define FREE(x) do { if(x) {free(x); x = NULL;} } while (0)
#define READ_N_BYTES(dest, src, n)  memcpy((dest), (src), (n));
#define WRITE_N_BYTES(dest, src, n)  memcpy((dest), (src), (n));

enum twamp_log_level {
	SCRIT,
	SERROR,
	SWARNING,
	SNOTICE,
	SINFO,
	SDEBUG,
	__MAX_SLOG
};

void print_crit(const char *format, ...);
void print_notice(const char *format, ...);
void print_error(const char *format, ...);
void print_warning(const char *format, ...);
void print_info(const char *format, ...);
void print_debug(const char *format, ...);

#define CRIT(fmt, args...) \
	print_crit("[%s:%d]"fmt, __func__, __LINE__, ##args)

#define NOTICE(fmt, args...) \
	print_notice("[%s:%d]"fmt, __func__, __LINE__, ##args)

#define DEBUG(fmt, args...) \
	print_debug("[%s:%d]"fmt, __func__, __LINE__, ##args)

#define INFO(fmt, args...) \
	print_info(fmt, ##args)

#define ERR(fmt, args...) \
	print_error("[%s:%d] " fmt, __func__, __LINE__, ##args)

#define WARNING(fmt, args...) \
	print_warning("[%s:%d] " fmt, __func__, __LINE__, ##args)

typedef struct refl_cfg {
	bool ref_enable;
	int ip_ver;
	int ref_port;
	int ref_ttl;
	char ref_intf[16];
	char ref_dev[16];
	char ref_ip_allow[1024];
	char ref_port_allow[1024];
} twamp_ref_cfg_t;

typedef struct glob_cfg {
	bool twamp_enable;
	int log_level;
} twamp_glob_cfg_t;

typedef struct ntp_time {
	uint32_t int_val;
	uint32_t frac_val;
} twamp_ntptime_t;

void twamp_log_init(int loglevel);
int twamp_get_uci_config(twamp_ref_cfg_t **ref_cfg, twamp_glob_cfg_t *glb_cfg);
uint64_t convert_to_usec(const twamp_ntptime_t *ts);
twamp_ntptime_t get_current_timestamp(void);

#endif // end of _COMMON_H_
