#!/bin/bash

function cleanup()
{
	echo ""
}

function check_ret()
{
	ret=$1
	if [ "$ret" -ne 0 ]; then
		echo "Validation of last command failed, ret(${ret})"
		exit $ret
	fi

}

function error_on_zero()
{
	ret=$1
	if [ "$ret" -eq 0 ]; then
		echo "Validation of last command failed, ret(${ret})"
		exit -1
	fi

}

function exec_cmd()
{
	echo "executing $@"
	$@ >/dev/null 2>&1

	if [ $? -ne 0 ]; then
		echo "Failed to execute $@"
		exit 1
	fi
}

function twamp_make()
{
	echo "Installing twamp and dm plugin"
	CFLAGS='-Wall -Werror -g -O0 -fprofile-arcs -ftest-coverage' LDFLAGS='--coverage -lpthread' make
	check_ret $?
}

function twamp_clean()
{
	make clean
	rm *.gcno *.gcda *.xml *.log
}

function generate_report()
{
	exec_cmd tap-junit --name "${1}" --input "${2}" --output report
	sync
}

function install_bbfdm()
{
	[ -d "/opt/dev/bbfdm" ] && return 0

	if [ -n "${BBFDM_BRANCH}" ]; then
		exec_cmd git clone -b ${BBFDM_BRANCH} https://dev.iopsys.eu/bbf/bbfdm.git /opt/dev/bbfdm
	else
		exec_cmd git clone https://dev.iopsys.eu/bbf/bbfdm.git /opt/dev/bbfdm
	fi

	cd /opt/dev/bbfdm
	./gitlab-ci/install-dependencies.sh install
	./gitlab-ci/setup.sh install
}

