#!/bin/bash

pwd
source ./gitlab-ci/shared.sh

date +%s > timestamp
function check_result()
{
	test="${1}"
	result="${2}"
	echo ${result} |grep -q "100% loss"
	if [ "$?" -eq 0 ]; then
		echo "Test ${test} failed"
		return -1
	else
		echo "Test ${test} pass"
		return 0
	fi
}

# install twampy
if [ ! -d "/opt/dev/twampy" ]; then
	exec_cmd git clone https://github.com/nokia/twampy.git /opt/dev/twampy
fi

# building twamp
twamp_clean
twamp_make
ln -s ${PWD}/twampd /usr/sbin/twampd

echo "Running functional Tests"
supervisorctl update
supervisorctl restart all
sleep 5
supervisorctl status all
ubus wait_for bbfdm

echo "TWAMP light Test"
result=`python3 /opt/dev/twampy/twampy.py sender -c 1 127.0.0.1:862`
check_result TWAMP_Light "${result}"
check_ret $?

result=`python3 /opt/dev/twampy/twampy.py sender -c 1 127.0.0.1:863`
check_result TWAMP_Light_2 "${result}"
check_ret $?

echo "TWAMP Test"
#result=`python3 /opt/dev/twampy/twampy.py controller -c 1 127.0.0.1:862`
#check_result TWAMP_Light "${result}"

supervisorctl stop all
supervisorctl status

#report part
gcovr -r . --xml -o ./test-coverage.xml
gcovr -r .

echo "Checking memory leaks..."
grep -q "Leak" /tmp/memory-report.xml
error_on_zero $?

echo "All test done"

