# TWAMP Light
TWAMP Light is an open protocol defined in TR-390.

## Configuration File

The `twampd` UCI configuration is located in **'/etc/config/twamp'**, and contains 2 sections the **twamp** and the **twamp\_reflector**.

```bash
config twamp 'twamp'
        option enable '1'
        option log_level '3'

config twamp_reflector 'reflector_1'
        option enable '0'
        option interface 'wan'
        option port '862'
        option max_ttl '1'
```

Detailed UCI parameter description available in [RAW format](./schemas/uci/twamp.json) or [UCI documentation](./docs/api/uci/twamp.md)

## Dependencies

To successfully build `twampd`, the following libraries are needed:

| Dependency  | Link                                        | License        |
| ----------- | ------------------------------------------- | -------------- |
| libuci      | https://git.openwrt.org/project/uci.git     | LGPL 2.1       |
| libubox     | https://git.openwrt.org/project/libubox.git | BSD            |
| libubus     | https://git.openwrt.org/project/ubus.git    | LGPL 2.1       |
| libbbfdm    | https://dev.iopsys.eu/bbf/bbfdm.git           | BSD-3       |

