# TR143d

TR143d package provides 'Device.IP.Diagnostics.' datamodel parameters and manages the backend for various diagnostic operations.

## Good to Know

It currently supports IPPing, Traceroute, DownloadDiagnostics, UploadDiagnostics, UDPEchoDiagnostics and ServerSelectionDiagnostics.

The datamodel implementation has been written in 'C' programming language and is being installed as a bbfdm micro-service to expose the datamodel functionality. The backend of various diagnostics are implemented using 'shell' programming.

Currently `DownloadDiagnostics` has two variant, for `an7581` based chipsets, its usages Airoha fastpath tr143 implementation using `speed_test` module, for rest of the platforms it mostly relies on Curl utility.

### Limitations with fastpath/speed_test module for DownloadDiagnostic

- Only available for `an7581` chip targets
- 'speed_test' module does not support 'https' protocol
- This module do not provide protocol based error codes when fails, so to show the actual failure in the output, current implementation uses libcurl to collect the exact error code.
- This module fails to download with IPv6 address so backend uses legacy mechanism (i.e. curl) to perform the diagnostic with IPv6 addresses.
- DownloadDiagnostic with 'FTP' protocol is not yet implemented with 'speed_test' and hence depends on the curl based mechanism.
- 'speed_test' module provides the timestamps for all time related parameters like ROMTime, BOMTime, EOMTime etc as below:
  ROMTime:(1751006637:323389120)
  BOMTime:(1751006637:388715440)
  EOMTime:(1751006638:500266320)

  As per our understanding the second part after the ':' should be in usec unit, but usec couldn't be in 9 digits form. So currently backend treats it as nsec and converts it to usec to produce the output.

### Summary
- Airoha fastpath (speed_test module) currently used in 'DownloadDiagnostics' on an7581 platform and it only works with 'http' protocol on 'IPv4' network.
