#!/bin/bash

pwd
source ./gitlab-ci/shared.sh

echo "Installing tr104 as plugins ..."
install_tr104_as_bbfdm_plugin

echo "Running functional Tests ..."

supervisorctl stop all
supervisorctl update
supervisorctl restart all
sleep 5
supervisorctl status all
ubus wait_for bbfdm

if ! bbfdmd -c get Device.Services. ;then
	echo "Failed to get the datamodel"
	exit 0
fi

supervisorctl stop all
supervisorctl status

cp /tmp/memory-report.xml .
valgrind-ci memory-report.xml --summary
exec_cmd valgrind-ci memory-report.xml --abort-on-errors

echo "All test done"

