#!/bin/bash

exec_cmd()
{
	echo "Executing [$*]"
	if ! $@; then
		echo "Failed to execute [$*]"
		exit -1
	fi
}

install_iowrt()
{
	echo "Compiling IOWRT version"
	[ -d "builds" ] && rm -rf builds

	mkdir -p builds
	cd builds

	exec_cmd cmake -DBBF_VENDOR_PREFIX:String="X_IOWRT_EU" -DCMAKE_INSTALL_PREFIX:PATH=/ -DCMAKE_VERBOSE_MAKEFILE=ON -DDM_ENABLE_UBUS=ON -DTR104_EXTENSION_DIR:String="iowrt" ../
	exec_cmd make
	exec_cmd make install
	cd ..

	[ -d "builds" ] && rm -rf builds
}

install_rdk()
{
	echo "Compiling RDK version"
	# RDK specific compilation
	# exec_cmd cmake -DCMAKE_INSTALL_PREFIX:PATH=/ -DCMAKE_VERBOSE_MAKEFILE=ON -DDM_ENABLE_UBUS=ON -DTR104_EXTENSION_DIR:String="iowrt" ../
	# exec_cmd make
	# exec_cmd make install
}

install_iowrt
install_rdk

date +%s > timestamp.log
