#include "servicesvoiceservicesip.h"

static int get_ServicesVoiceServiceSIPInterface(char *refparam, struct dmctx *ctx, void *data, char *instance, char **value)
{
	char *interface = NULL;

	dmuci_get_option_value_string("asterisk", "sip_options", "bindintf", &interface);
	if (DM_STRLEN(interface)) {
		_bbfdm_get_references(ctx, "Device.IP.Interface.", "Name", interface, value);
	} else {
		*value = dmstrdup("");
	}

	return 0;
}

static int set_ServicesVoiceServiceSIPInterface(char *refparam, struct dmctx *ctx, void *data, char *instance, char *value, int action)
{
	char *allowed_objects[] = {"Device.IP.Interface.", NULL};
	struct dm_reference reference = {0};

	bbfdm_get_reference_linker(ctx, value, &reference);
	switch (action)	{
		case VALUECHECK:
			if (bbfdm_validate_string(ctx, value, -1, 256, NULL, NULL))
				return FAULT_9007;

			if (dm_validate_allowed_objects(ctx, &reference, allowed_objects))
				return FAULT_9007;
			break;
		case VALUESET:
			if (DM_STRLEN(reference.path)) {
				dmuci_set_value("asterisk", "sip_options", "bindintf", reference.value);
			} else {
				dmuci_set_value("asterisk", "sip_options", "bindintf", "");
			}
			break;
	}
	return 0;
}

DMLEAF tIOPSYS_VoiceServiceSIPParams[] = {
/* PARAM, permission, type, getvalue, setvalue, bbfdm_type*/
{BBF_VENDOR_PREFIX"Interface", &DMWRITE, DMT_STRING, get_ServicesVoiceServiceSIPInterface, set_ServicesVoiceServiceSIPInterface, BBFDM_BOTH, DM_FLAG_REFERENCE},
{0}
};
