# TR104 Datamodel Daemon

TR104 is a diverged fork of [BBFDM](https://dev.iopsys.eu/bbf/bbfdm.git), aim of this repo is to provide the datamodel layer for TR104 and TR104-extensions.

For design and architecture refer to [BBFDM](https://dev.iopsys.eu/bbf/bbfdm.git).

## TR104 supported Interfaces

TR104 supports following northbound interfaces:

- Ubus - for seamless integration with OpenWRT based solutions
- JSON-RPC - for integration with RDK-B based solutions

South bound interfaces are implementation dependent, but it support extending datamodel with
- UCI
- UBUS
- System calls

## Debugging support

Similar to `bbfdmd`, `tr104d` also provides a cli debug utility to interact with datamodel

```bash
root@eagle-44d43771b500:~# tr104d -c help
Valid commands:
   help
   get [path-expr]
   set [path-expr] [value]
   add [object]
   del [path-expr]
   instances [path-expr]
   schema [path-expr]
root@eagle-44d43771b500:~#
```


> Note: This cli utility shall only be used for debugging, as it has datamodel parameters for TR104 only and some datamodel references might show metadata

ex:
```bash
root@eagle-44d43771b500:~# tr104d -c get Device.
Device.Services.X_IOPSYS_EU_VoiceHalInit => 0
Device.Services.VoiceService.1.Alias => cpe-1

...

Device.Services.VoiceService.1.CodecProfile.1.Codec => Device.Services.VoiceService.*.Capabilities.Codec.[Codec=="G.711ALaw"].
Device.Services.VoiceService.1.CodecProfile.1.PacketizationPeriod => 20
Device.Services.VoiceService.1.CodecProfile.1.Alias => cpe-1
```

## Directory structure

This implementation comprises of the three main components:

```
├── daemon
│   ├── json_rpc  -- Daemon with JSON-RPC northbound interface
│   └── ubus      -- Daemon with UBUS northbound interface
├── libdm
│   ├── tr104     -- Contains TR104 specific datamodel definitions as per DotSO plugin
│   └── tr104_ext -- Contains TR104 vendor extensions
└── libdmtree     -- A Static library with APIs to traverse datamodel tree, used by daemon
```


| Component  |                    Description                    |
| ---------- | ------------------------------------------------- |
| daemon | Daemon which used to expose data model object |
| libdmtree  | It is a static library that provides many APIs used to interact with UCI configurations, Ubus objects, JSON schema, CLI commands and memory management. It also provides a mechanism to add new objects, parameters, events and operates or extend the existing DM tree using json plugin or shared library plugin. |
| libdm  | A shared library that provides the tr104 datamodel tree |


## How to extend the TR104 datamodel

In case of `UBUS` daemon `tr104d`, its deployed using [datamodel micro-services](https://dev.iopsys.eu/bbf/bbfdm/-/blob/devel/docs/guide/datamodel_as_microservice.md), which provides a way to extend the datamodel further using DotSO and JSON plugins.

User has to create a DotSO or JSON plugin and then install it pre-defined tr104 plugin directory `/etc/tr104/plugins/` [reference](https://dev.iopsys.eu/feed/iopsys/-/blob/devel/tr104/files/etc/tr104/input.json)

