# Time Manager Daemon

Time manager Daemon or timemngrd is a BBFDM datamodel micro-service, to provide/manage the Device.Time. object based on TR181-2.16

# Device.Time datamodel implementation as per version 2.16
In datamodel version 2.16 the Device.Time object is completely restructured and
to support the new version which includes Device.Time.Client and Device.Time.Server
objects we had to reconsider the old implementation of Device.Time in BBF.

## Why old implementation can not be re-used or enhanced

- With old implementation it was not possible to support the new object and parameters
  of datamodel version 2.16.
- Old implementation was using "system" uci file for configuration and "ntpd" package
  for the protocol back end.
  "system" uci parameters are one to one mapped with datamodel parameters older than
  2.16 version and are tightly coupled as shown below:

```
    config timeserver 'ntp'
          option enabled '1'			/* Device.Time.Enable in version < 2.16 */
          list server 'ntp1.sth.netnod.se'	/* Device.Time.NTPServer1 in version < 2.16 */
          list server 'ntp1.gbg.netnod.se'	/* Device.Time.NTPServer2 and so on */
```

- With standard "system" uci options and ntpd init script below parameters of datamodel ver-2.16 can not be supported:
    1. Device.Time.Client.{i}.Mode
    2. Device.Time.Client.{i}.Version
    3. Device.Time.Client.{i}.Peer
    4. Device.Time.Client.{i}.Iburst
    5. Device.Time.Server.{i}.Mode
    6. Device.Time.Server.{i}.TTL

- Multiple instances can not be supported.

## Selection of package

There are a few packages available for time sync, like: busybox-ntpd, ntpclient and ntpd (ISC).
Out of these packages 'ntpd'(ISC) has been selected for below reasons:

  - ntpd (ISC) package supports most of the datamodel parameters of version 2.16
  - busybox-ntpd provides a light weight binary which is not compatible with most of the datamodel
    parameters.
  - ntpclient package only works as a client and also supports very less parameters.

## Limitations with datamodel version 2.16

### Due to the limitations in NTP package, we can not support below datamodel parameters:

  - Device.Time.Client.{i}.BindType => NTPD package has no support of socket binding type
  - Device.Time.Client.{i}.ResolveAddress => No such configuration is available in NTPD package
  - Device.Time.Client.{i}.ResolveMaxAddress => No such configuration available in NTPD package
  - Device.Time.Client.{i}.Burst => The definition of this param in Datamodel differs the definition of NTPD package
  - Device.Time.Server.{i}.BindType => No support in NTPD package
  - Device.Time.Server.{i}.MinPoll => Min polling interval option is not available with server in NTPD package
  - Device.Time.Server.{i}.MaxPoll => Max polling interval option is not available with server in NTPD package

### Below datamodel parameters could be partly supported:

  - Device.Time.Client.{i}.Interface => NTPD package has its own algo to detect the interface to communicate with servers,
                                       so we can not restrict NTP client to communicate on any specific interface but we will
				       keep this parameter to identify the interface on which DHCP offers will be processed
				       to find if any NTP server configuration is available from DHCP server. 
  - Device.Time.Client.{i}.Port => This could be supported as read only parameter since NTPD uses standard NTP port 123 and is
                                  not configurable.
  - Device.Time.Server.{i}.Port => This could be supported as read only parameter.

## Considerations with new implementation

- Since "ntpd" package reads "system" uci and the "system" uci does not support new datamodel
  parameters so no more use /etc/config/system uci file for Device.Time.
- Create a seperate uci & init script, which will further generate the config file for the
  NTP daemon. Below is the proposed UCI config:

```
    config global 'global'
          option enable '1'

    config client 'client'
          option enable '1'
          option iburst '1'
          option version '4'
          option peer '0'
          option minpoll '6'
          option maxpoll '10'
          option mode 'Unicast'
          option server 'ntp1.sth.netnod.se,ntp1.gbg.netnod.se'

    config server 'server'
          option enable 1'
          option mode 'Unicast'
          option ttl '255'
          option interface 'lan'
```

- ntpd package does not allow to start multiple client and multiple server, so we can support
  only one instances of client and server. Due to this "Device.Time.Server." will be supported
  as single instance object.

- Since we need to handle the NTP server addresses received in DHCP offer, we would allow
  "Device.Time.Client." as multi-instance object but due to the limitation of ntpd package we
  will allow to enable only one client instance at a time.

- By default one instance of Device.Time.Client object will exist with `dhcp_discovery` option
  enabled and with default NTP servers and this instance is enabled by default.
  The `interface` option of this instance is set to 'wan'. So on "wan" interface if DHCP offer
  consists of any NTP server address then the 'server' parameter of this instance will be
  updated by the hotplug and ntpd will start syncing with DHCP provided servers.

- On creation of new client instance the `dhcp_discovery` option of that instance would be
  enabled by default.

- Whenever any NTP server is added to any client instance through management methods, the
  `dhcp_discovery` would be disabled for that client instance. Deleting the servers would
  again enable the `dhcp_discovery` for that instance.

- If mode of the Device.Time.Server object is set to "Broadcast" then it is must to set the
  Device.Time.Server.Interface. This interface value is used to configure the broadcast address,
  the NTP server will use.
