/*
 * Copyright (C) 2023 iopsys Software Solutions AB
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 2.1
 * as published by the Free Software Foundation
 *
 *	  Author: Suvendhu Hansa <suvendhu.hansa@iopsys.eu>
 *
 */

#ifndef __HELPER_H
#define __HELPER_H

#include <syslog.h>
#include <libubox/blobmsg.h>
#include <libubox/blobmsg_json.h>

struct time_args {
	unsigned int pack_sent;
	unsigned int pack_sent_fail;
	unsigned int pack_recv;
	unsigned int pack_drop;
	char status[32];
};

void print_log(int severity, const char *format, ...);

#define PRINT_DEBUG(fmt, args...) \
	print_log(LOG_DEBUG, "[%s:%d]"fmt, __func__, __LINE__, ##args)

#define PRINT_INFO(fmt, args...) \
	print_log(LOG_INFO, "[%s:%d] " fmt, __func__, __LINE__, ##args)

#define PRINT_ERR(fmt, args...) \
	print_log(LOG_ERR, "[%s:%d] " fmt, __func__, __LINE__, ##args)

#define TIME_STRCMP(S1, S2) time_strcmp(S1, S2, __func__, __LINE__)
#define TIME_STRLEN(S1) time_strlen(S1, __func__, __LINE__)
#define TIME_STRSTR(S1, S2) time_strstr(S1, S2, __func__, __LINE__)
#define TIME_STRNCPY(S1, S2, N) time_strncpy(S1, S2, N, __func__, __LINE__)

int time_strcmp(const char *s1, const char *s2, const char *origin, int pos);
int time_strlen(const char *s1, const char *origin, int pos);
char *time_strstr(const char *s1, const char *s2, const char *origin, int pos);
char *time_strncpy(char *s1, const char *s2, size_t n, const char *origin, int pos);

void fill_time_args(const char *obj, const char *sec, struct time_args *time_stats);

bool ntpd_time_sync(void);

#endif
