/*
 * swmod_uci.h: uci utilities
 *
 * Copyright (C) 2020-2023 IOPSYS Software Solutions AB. All rights reserved.
 *
 * Author: Amin Ben Ramdhane <amin.benramdhane@pivasoftware.com>
 *
 * See LICENSE file for license related information.
 */

#ifndef __SWMOD_UCI_H
#define __SWMOD_UCI_H

#include <uci.h>

int swmod_uci_init(const char *conf_path);
int swmod_uci_fini(const char *package_name);

struct uci_section *swmod_uci_add_section(const char *package, const char *section_type, bool rename);
int swmod_uci_delete_by_section(struct uci_section *section, const char *option, const char *value);

char *swmod_uci_get_value_by_section(struct uci_section *section, const char *option);
char *swmod_uci_set_value_by_section(struct uci_section *section, const char *option, const char *value);
char *swmod_uci_set_value_by_section_list(struct uci_section *section, const char *option, const char *value);

struct uci_section *swmod_uci_walk_section(const char *package, const char *section_type, struct uci_section *prev_section);

bool check_section_exist_by_option(const char *section, const char *section_type, const char *option, const char *val_check, struct uci_section **s);

bool uci_str_to_bool(const char *value);
int swmod_uci_commit(char *package);

#define swmod_uci_foreach_section(package, section_type, section) \
	for (section = swmod_uci_walk_section(package, section_type, NULL); \
		section != NULL; \
		section = swmod_uci_walk_section(package, section_type, section))

#define swmod_uci_foreach_section_safe(package, section_type, _tmp, section) \
	for(section = swmod_uci_walk_section(package, section_type, NULL), \
		_tmp = (section) ? swmod_uci_walk_section(package, section_type, section) : NULL; \
		section != NULL; \
		section = _tmp, _tmp = (section) ? swmod_uci_walk_section(package, section_type, section) : NULL)

#endif //__SWMOD_UCI_H
