/*
 * swmod_lxc.h: APIs to manage lxc based containers
 *
 * Copyright (C) 2020-2023 IOPSYS Software Solutions AB. All rights reserved.
 *
 * Author: Amin Ben Ramdhane <amin.benramdhane@pivasoftware.com>
 *
 * See LICENSE file for license related information.
 */

#ifndef LXC_H
#define LXC_H

#include <stdbool.h>
#include <libubox/blobmsg.h>
#include <libubox/list.h>
#include <lxc/lxccontainer.h>

#include "swmod_common.h"

bool lxc_is_supported(const char **lxcpath);
const char *get_lxc_path_from_config(void);
void populate_lxc_environment(struct list_head *ee_list, const char *lxc_oci_path);
void populate_lxc_du(void);
int swmod_lxc_install_update_remove_package(const PkgInfo *pkg, char *out, int outlen, const char *ct_name, int action);
void populate_lxc_eu(ExecEnv_t *env, const char *lxc_uci_path);
void get_pid_details_lxc(ExecEnv_t *env, int pid, char *cmdline, int cmd_len, int *vsize);
int swmod_set_lxc_service_state(ExecEnv_t *env, char *name, bool state, const char *lxc_uci_path);
int swmod_set_lxc_ee_state(ExecEnv_t *env, char *state, const char *lxc_uci_path);
int lxc_run_cmd(ExecEnv_t *ee, const char *cmd, char *output, int out_len);
void get_lxc_environment_info(ExecEnv_t *ee, const char *lxc_uci_path);
void get_service_list(char *object, char *method, ubus_data_handler_t callback, void *data);
int set_lxc_alias(const char *ee_name, const char *alias, const char *bundle);

#endif //LXC_H
